/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.config;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.BaseUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class BeanDefinitionUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(BeanDefinitionUtils.class);

    public static AbstractBeanDefinition genericBeanDefinition(Class<?> beanType) {
        return BeanDefinitionUtils.genericBeanDefinition(beanType, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static AbstractBeanDefinition genericBeanDefinition(Class<?> beanType, Object ... constructorArguments) {
        return BeanDefinitionUtils.genericBeanDefinition(beanType, 0, constructorArguments);
    }

    public static AbstractBeanDefinition genericBeanDefinition(Class<?> beanType, int role) {
        return BeanDefinitionUtils.genericBeanDefinition(beanType, role, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static AbstractBeanDefinition genericBeanDefinition(Class<?> beanType, int role, Object[] constructorArguments) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanType).setRole(role);
        int length = ArrayUtils.length((Object[])constructorArguments);
        for (int i = 0; i < length; ++i) {
            Object constructorArgument = constructorArguments[i];
            beanDefinitionBuilder.addConstructorArgValue(constructorArgument);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getBeanDefinition();
        return beanDefinition;
    }

    public static Class<?> resolveBeanType(RootBeanDefinition beanDefinition) {
        return BeanDefinitionUtils.resolveBeanType(beanDefinition, ClassLoaderUtils.getDefaultClassLoader());
    }

    public static Class<?> resolveBeanType(RootBeanDefinition beanDefinition, @Nullable ClassLoader classLoader) {
        Class beanClass = null;
        Method factoryMethod = beanDefinition.getResolvedFactoryMethod();
        if (factoryMethod == null) {
            if (beanDefinition.hasBeanClass()) {
                beanClass = beanDefinition.getBeanClass();
            } else {
                String beanClassName = beanDefinition.getBeanClassName();
                if (StringUtils.hasText((String)beanClassName)) {
                    beanClass = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)classLoader);
                }
            }
        } else {
            beanClass = factoryMethod.getReturnType();
        }
        return beanClass;
    }

    public static Set<String> findInfrastructureBeanNames(ConfigurableListableBeanFactory beanFactory) {
        return BeanDefinitionUtils.findBeanNames(beanFactory, BeanDefinitionUtils::isInfrastructureBean);
    }

    public static Set<String> findBeanNames(ConfigurableListableBeanFactory beanFactory, Predicate<BeanDefinition> predicate) {
        String[] beanDefinitionNames;
        if (predicate == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> matchedBeanNames = new LinkedHashSet<String>();
        for (String beanDefinitionName : beanDefinitionNames = beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanDefinitionName);
            if (!predicate.test(beanDefinition)) continue;
            matchedBeanNames.add(beanDefinitionName);
        }
        return Collections.unmodifiableSet(matchedBeanNames);
    }

    public static boolean isInfrastructureBean(BeanDefinition beanDefinition) {
        return beanDefinition != null && 2 == beanDefinition.getRole();
    }
}

