/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.support;

import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.ListUtils;
import io.microsphere.spring.beans.factory.support.AutowireCandidateResolvingListener;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.util.Assert;

public class CompositeAutowireCandidateResolvingListener
implements AutowireCandidateResolvingListener {
    private final List<AutowireCandidateResolvingListener> listeners = new LinkedList<AutowireCandidateResolvingListener>();

    public CompositeAutowireCandidateResolvingListener(List<AutowireCandidateResolvingListener> listeners) {
        Assert.isTrue((boolean)CollectionUtils.isNotEmpty(listeners), (String)"The argument 'listeners' must not be empty!");
        this.addListeners(listeners);
    }

    public void addListeners(List<AutowireCandidateResolvingListener> listeners) {
        ListUtils.forEach(listeners, listener -> {
            Assert.notNull((Object)listener, (String)"The element 'listener' must not be null!");
            this.listeners.add((AutowireCandidateResolvingListener)listener);
        });
        AnnotationAwareOrderComparator.sort(this.listeners);
    }

    @Override
    public void suggestedValueResolved(DependencyDescriptor descriptor, Object suggestedValue) {
        ListUtils.forEach(this.listeners, listener -> listener.suggestedValueResolved(descriptor, suggestedValue));
    }

    @Override
    public void lazyProxyResolved(DependencyDescriptor descriptor, String beanName, Object proxy) {
        ListUtils.forEach(this.listeners, listener -> listener.lazyProxyResolved(descriptor, beanName, proxy));
    }
}

