/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.support;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.support.AutowireCandidateResolvingListener;
import io.microsphere.spring.beans.factory.support.BeanRegistrar;
import io.microsphere.spring.beans.factory.support.CompositeAutowireCandidateResolvingListener;
import io.microsphere.util.ArrayUtils;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class ListenableAutowireCandidateResolver
implements AutowireCandidateResolver,
BeanFactoryPostProcessor,
EnvironmentAware,
BeanNameAware {
    private static final Logger logger = LoggerFactory.getLogger(ListenableAutowireCandidateResolver.class);
    public static final String PROPERTY_NAME_PREFIX = "microsphere.spring.listenable-autowire-candidate-resolver.";
    public static final String ENABLED_PROPERTY_NAME = "microsphere.spring.listenable-autowire-candidate-resolver.enabled";
    public static final boolean ENABLED_PROPERTY_VALUE = false;
    private AutowireCandidateResolver delegate;
    private CompositeAutowireCandidateResolvingListener compositeListener;
    private Environment environment;
    private String beanName;

    public void addListener(AutowireCandidateResolvingListener one, AutowireCandidateResolvingListener ... more) {
        this.addListeners((AutowireCandidateResolvingListener[])ArrayUtils.combine((Object)one, (Object[])more));
    }

    public void addListeners(AutowireCandidateResolvingListener[] listeners) {
        this.addListeners(Arrays.asList(listeners));
    }

    public void addListeners(List<AutowireCandidateResolvingListener> listeners) {
        this.compositeListener.addListeners(listeners);
    }

    public boolean isAutowireCandidate(BeanDefinitionHolder bdHolder, DependencyDescriptor descriptor) {
        return this.delegate.isAutowireCandidate(bdHolder, descriptor);
    }

    public boolean isRequired(DependencyDescriptor descriptor) {
        return this.delegate.isRequired(descriptor);
    }

    public boolean hasQualifier(DependencyDescriptor descriptor) {
        return this.delegate.hasQualifier(descriptor);
    }

    @Nullable
    public Object getSuggestedValue(DependencyDescriptor descriptor) {
        Object suggestedValue = this.delegate.getSuggestedValue(descriptor);
        this.compositeListener.suggestedValueResolved(descriptor, suggestedValue);
        return suggestedValue;
    }

    @Nullable
    public Object getLazyResolutionProxyIfNecessary(DependencyDescriptor descriptor, String beanName) {
        Object proxy = this.delegate.getLazyResolutionProxyIfNecessary(descriptor, beanName);
        this.compositeListener.lazyProxyResolved(descriptor, beanName, proxy);
        return proxy;
    }

    public AutowireCandidateResolver cloneIfNecessary() {
        return this.delegate.cloneIfNecessary();
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.wrap((BeanFactory)beanFactory);
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void wrap(BeanFactory beanFactory) {
        DefaultListableBeanFactory dbf;
        AutowireCandidateResolver autowireCandidateResolver;
        if (!ListenableAutowireCandidateResolver.isEnabled(this.environment)) {
            if (logger.isInfoEnabled()) {
                logger.info("The ListenableAutowireCandidateResolver bean[name : '{}'] is disabled.", new Object[]{this.beanName});
                logger.info("Setting the configuration property '{} = true' to enable it if requires.", new Object[]{ENABLED_PROPERTY_NAME});
            }
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("The ListenableAutowireCandidateResolver bean[name : '{}'] is enabled.", new Object[]{this.beanName});
        }
        if ((autowireCandidateResolver = (dbf = BeanFactoryUtils.asDefaultListableBeanFactory(beanFactory)).getAutowireCandidateResolver()) != null) {
            List<AutowireCandidateResolvingListener> listeners = AutowireCandidateResolvingListener.loadListeners(beanFactory);
            CompositeAutowireCandidateResolvingListener compositeListener = new CompositeAutowireCandidateResolvingListener(listeners);
            this.delegate = autowireCandidateResolver;
            this.compositeListener = compositeListener;
            dbf.setAutowireCandidateResolver((AutowireCandidateResolver)this);
        }
    }

    public static boolean isEnabled(Environment environment) {
        return (Boolean)environment.getProperty(ENABLED_PROPERTY_NAME, Boolean.TYPE, (Object)false);
    }

    public static void register(ConfigurableApplicationContext applicationContext) {
        ConfigurableListableBeanFactory beanFactory = applicationContext.getBeanFactory();
        BeanDefinitionRegistry beanDefinitionRegistry = BeanFactoryUtils.asBeanDefinitionRegistry(beanFactory);
        BeanRegistrar.registerInfrastructureBean(beanDefinitionRegistry, ListenableAutowireCandidateResolver.class);
    }
}

