/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.beans.factory.support;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.support.AutowireCandidateResolvingListener;
import org.springframework.beans.factory.config.DependencyDescriptor;

public class LoggingAutowireCandidateResolvingListener
implements AutowireCandidateResolvingListener {
    private static final Logger logger = LoggerFactory.getLogger(LoggingAutowireCandidateResolvingListener.class);

    @Override
    public void suggestedValueResolved(DependencyDescriptor descriptor, Object suggestedValue) {
        if (suggestedValue != null) {
            this.log("The suggested value for {} was resolved : {}", descriptor, suggestedValue);
        }
    }

    @Override
    public void lazyProxyResolved(DependencyDescriptor descriptor, String beanName, Object proxy) {
        if (proxy != null) {
            this.log("The lazy proxy[descriptor : {} , bean name : '{}'] was resolved : {}", descriptor, beanName, proxy);
        }
    }

    protected void log(String messagePattern, Object ... args) {
        if (logger.isTraceEnabled()) {
            logger.trace(messagePattern, args);
        }
    }
}

