/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config;

import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.support.AutowireCandidateResolvingListener;
import io.microsphere.spring.beans.factory.support.BeanRegistrar;
import io.microsphere.spring.config.ConfigurationProperty;
import io.microsphere.spring.config.ConfigurationPropertyRepository;
import io.microsphere.spring.core.env.PropertyResolverListener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.env.ConfigurablePropertyResolver;

public class CollectingConfigurationPropertyListener
implements PropertyResolverListener,
AutowireCandidateResolvingListener,
BeanFactoryAware {
    public static final String BEAN_NAME = "collectingConfigurationPropertyListener";
    private BeanFactory beanFactory;
    private ConfigurationPropertyRepository repository;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";

    @Override
    public void afterGetProperty(ConfigurablePropertyResolver propertyResolver, String name, Class<?> targetType, Object value, Object defaultValue) {
        ConfigurationProperty configurationProperty = this.getConfigurationProperty(name);
        configurationProperty.setType(targetType);
        configurationProperty.setValue(value);
        configurationProperty.setDefaultValue(defaultValue);
    }

    @Override
    public void afterGetRequiredProperty(ConfigurablePropertyResolver propertyResolver, String name, Class<?> targetType, Object value) {
        ConfigurationProperty configurationProperty = this.getConfigurationProperty(name);
        configurationProperty.setType(targetType);
        configurationProperty.setValue(value);
        configurationProperty.setRequired(true);
    }

    @Override
    public void afterResolvePlaceholders(ConfigurablePropertyResolver propertyResolver, String text, String result) {
    }

    @Override
    public void afterSetPlaceholderPrefix(ConfigurablePropertyResolver propertyResolver, String prefix) {
        this.placeholderPrefix = prefix;
    }

    @Override
    public void afterSetPlaceholderSuffix(ConfigurablePropertyResolver propertyResolver, String suffix) {
        this.placeholderSuffix = suffix;
    }

    @Override
    public void suggestedValueResolved(DependencyDescriptor descriptor, Object suggestedValue) {
        Value value = (Value)descriptor.getAnnotation(Value.class);
        if (value != null) {
            // empty if block
        }
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        BeanDefinitionRegistry registry = BeanFactoryUtils.asBeanDefinitionRegistry(beanFactory);
        BeanRegistrar.registerBeanDefinition(registry, "configurationPropertyRepository", ConfigurationPropertyRepository.class);
        BeanRegistrar.registerBean(registry, BEAN_NAME, this);
    }

    private ConfigurationProperty getConfigurationProperty(String name) {
        return this.getRepository().createIfAbsent(name);
    }

    private ConfigurationPropertyRepository getRepository() {
        if (this.repository == null) {
            this.repository = (ConfigurationPropertyRepository)this.beanFactory.getBean("configurationPropertyRepository", ConfigurationPropertyRepository.class);
        }
        return this.repository;
    }
}

