/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config;

import io.microsphere.util.Assert;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ConfigurationProperty {
    @Nonnull
    private final String name;
    @Nonnull
    private Class<?> type;
    @Nullable
    private Object value;
    @Nullable
    private Object defaultValue;
    private boolean required;
    @Nonnull
    private final Metadata metadata;

    public ConfigurationProperty(String name) {
        this(name, String.class);
    }

    public ConfigurationProperty(String name, Class<?> type) {
        Assert.assertNotNull((Object)name, () -> "the property name must not null");
        this.name = name;
        this.setType(type);
        this.metadata = new Metadata();
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nonnull
    public Class<?> getType() {
        return this.type;
    }

    public void setType(@Nonnull Class<?> type) {
        Assert.assertNotNull(type, () -> "the property type must not null");
        this.type = type;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public void setValue(@Nullable Object value) {
        this.value = value;
    }

    @Nullable
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(@Nullable Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Nonnull
    public Metadata getMetadata() {
        return this.metadata;
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ConfigurationProperty)) {
            return false;
        }
        ConfigurationProperty that = (ConfigurationProperty)o;
        return this.isRequired() == that.isRequired() && this.getName().equals(that.getName()) && this.getType().equals(that.getType()) && Objects.equals(this.getValue(), that.getValue()) && Objects.equals(this.getDefaultValue(), that.getDefaultValue()) && Objects.equals(this.getMetadata(), that.getMetadata());
    }

    public int hashCode() {
        int result = this.getName().hashCode();
        result = 31 * result + this.getType().hashCode();
        result = 31 * result + Objects.hashCode(this.getValue());
        result = 31 * result + Objects.hashCode(this.getDefaultValue());
        result = 31 * result + Boolean.hashCode(this.isRequired());
        result = 31 * result + Objects.hashCode(this.getMetadata());
        return result;
    }

    public String toString() {
        return "ConfigurationProperty{name='" + this.name + "', type=" + this.type + ", value=" + this.value + ", defaultValue=" + this.defaultValue + ", required=" + this.required + ", metadata=" + this.metadata + "}";
    }

    public static class Metadata {
        private String description;
        private Set<String> targets = new LinkedHashSet<String>(8);

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public Set<String> getTargets() {
            return this.targets;
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata metadata = (Metadata)o;
            return Objects.equals(this.description, metadata.description) && Objects.equals(this.targets, metadata.targets);
        }

        public int hashCode() {
            int result = Objects.hashCode(this.description);
            result = 31 * result + Objects.hashCode(this.targets);
            return result;
        }

        public String toString() {
            return "Metadata{description='" + this.description + "', targets=" + this.targets + "}";
        }
    }
}

