/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config;

import io.microsphere.spring.config.ConfigurationProperty;
import io.microsphere.text.FormatUtils;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class ConfigurationPropertyRepository
implements EnvironmentAware,
InitializingBean,
DisposableBean {
    public static final String BEAN_NAME = "configurationPropertyRepository";
    public static final String PROPERTY_NAME_PREFIX = "microsphere.spring.config-property-repository.";
    public static final String MAX_SIZE_PROPERTY_NAME = "microsphere.spring.config-property-repository.max-size";
    public static final int DEFAULT_MAX_SIZE_PROPERTY_VALUE = 99999;
    private int maxSize = 99999;
    private ConcurrentMap<String, ConfigurationProperty> repository;

    public void add(ConfigurationProperty configurationProperty) {
        this.assertMaxSize();
        String name = configurationProperty.getName();
        this.repository.put(name, configurationProperty);
    }

    public ConfigurationProperty remove(String name) {
        return (ConfigurationProperty)this.repository.remove(name);
    }

    public ConfigurationProperty get(String name) {
        return (ConfigurationProperty)this.repository.get(name);
    }

    public boolean contains(String name) {
        return this.repository.containsKey(name);
    }

    public ConfigurationProperty createIfAbsent(String name) {
        this.assertMaxSize();
        return this.repository.computeIfAbsent(name, ConfigurationProperty::new);
    }

    public Collection<ConfigurationProperty> getAll() {
        return this.repository.values();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setEnvironment(Environment environment) {
        this.maxSize = (Integer)environment.getProperty(MAX_SIZE_PROPERTY_NAME, Integer.TYPE, (Object)99999);
    }

    public void afterPropertiesSet() throws Exception {
        this.repository = new ConcurrentHashMap<String, ConfigurationProperty>(this.maxSize);
    }

    public void destroy() throws Exception {
        this.repository.clear();
    }

    private void assertMaxSize() {
        if (this.repository.size() >= this.maxSize) {
            String message = FormatUtils.format((String)"The size of repository is greater than max size : {}. If it requires to the greater threshold, change the configuration property : {}", (Object[])new Object[]{this.maxSize, MAX_SIZE_PROPERTY_NAME});
            throw new IllegalStateException(message);
        }
    }
}

