/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.context.annotation;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.context.annotation.BeanCapableImportCandidate;
import io.microsphere.spring.core.annotation.ResolvablePlaceholderAnnotationAttributes;
import io.microsphere.util.StringUtils;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;

public abstract class AnnotatedPropertySourceLoader<A extends Annotation>
extends BeanCapableImportCandidate
implements ImportSelector {
    private static final String[] NO_CLASS_TO_IMPORT = StringUtils.EMPTY_STRING_ARRAY;
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<A> annotationType = this.resolveAnnotationType();
    private String propertySourceName;

    protected Class<A> resolveAnnotationType() {
        ResolvableType type = ResolvableType.forType(this.getClass());
        ResolvableType superType = type.as(AnnotatedPropertySourceLoader.class);
        return superType.resolveGeneric(new int[]{0});
    }

    public final String[] selectImports(AnnotationMetadata metadata) {
        String propertySourceName;
        String annotationClassName = this.annotationType.getName();
        Map annotationAttributes = metadata.getAnnotationAttributes(annotationClassName);
        ResolvablePlaceholderAnnotationAttributes<A> attributes = ResolvablePlaceholderAnnotationAttributes.of(annotationAttributes, this.annotationType, (PropertyResolver)this.getEnvironment());
        this.propertySourceName = propertySourceName = this.resolvePropertySourceName(attributes, metadata);
        MutablePropertySources propertySources = this.getEnvironment().getPropertySources();
        try {
            this.loadPropertySource(attributes, metadata, propertySourceName, propertySources);
        }
        catch (Throwable e) {
            String errorMessage = "The Configuration bean[class : '" + metadata.getClassName() + "', annotated : @" + annotationClassName + "] can't load the PropertySource[name : '" + propertySourceName + "']";
            this.logger.error(errorMessage, e);
            throw new BeanCreationException(errorMessage, e);
        }
        return NO_CLASS_TO_IMPORT;
    }

    @Nonnull
    protected final String resolvePropertySourceName(AnnotationAttributes attributes, AnnotationMetadata metadata) {
        String name = this.buildPropertySourceName(attributes, metadata);
        if (!org.springframework.util.StringUtils.hasText((String)name)) {
            name = this.buildDefaultPropertySourceName(attributes, metadata);
        }
        return name;
    }

    @Nullable
    protected String buildPropertySourceName(AnnotationAttributes attributes, AnnotationMetadata metadata) {
        if (attributes.containsKey((Object)NAME_ATTRIBUTE_NAME)) {
            return attributes.getString(NAME_ATTRIBUTE_NAME);
        }
        return null;
    }

    @Nonnull
    protected String buildDefaultPropertySourceName(AnnotationAttributes attributes, AnnotationMetadata metadata) {
        String annotationClassName = this.annotationType.getName();
        String introspectedClassName = metadata.getClassName();
        return introspectedClassName + "@" + annotationClassName;
    }

    @Nullable
    protected abstract void loadPropertySource(AnnotationAttributes var1, AnnotationMetadata var2, String var3, MutablePropertySources var4) throws Throwable;

    @Nonnull
    public final Class<A> getAnnotationType() {
        return this.annotationType;
    }

    protected String getPropertySourceName() {
        return this.propertySourceName;
    }
}

