/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.context.annotation;

import io.microsphere.spring.config.context.annotation.DefaultPropertiesPropertySource;
import io.microsphere.spring.config.context.annotation.PropertySourceExtensionAttributes;
import io.microsphere.spring.config.context.annotation.ResourcePropertySource;
import io.microsphere.spring.config.context.annotation.ResourcePropertySourceLoader;
import io.microsphere.spring.context.annotation.BeanCapableImportCandidate;
import io.microsphere.spring.core.annotation.AnnotationUtils;
import io.microsphere.spring.core.env.PropertySourcesUtils;
import java.util.Map;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.type.AnnotationMetadata;

class DefaultPropertiesPropertySourceLoader
extends BeanCapableImportCandidate
implements ImportBeanDefinitionRegistrar {
    DefaultPropertiesPropertySourceLoader() {
    }

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        AnnotationAttributes attributes = AnnotationUtils.getAnnotationAttributes(metadata, DefaultPropertiesPropertySource.class);
        this.loadPropertySource(attributes, registry);
    }

    protected void loadPropertySource(AnnotationAttributes attributes, BeanDefinitionRegistry registry) {
        String propertySourceName = "defaultProperties@" + this.hashCode();
        ResourcePropertySourceLoader delegate = this.getDelegate();
        Map<String, Object> defaultProperties = PropertySourcesUtils.getDefaultProperties(this.environment);
        PropertySourceExtensionAttributes<ResourcePropertySource> extensionAttributes = this.buildExtensionAttributes(attributes);
        try {
            PropertySource<?> propertySource = delegate.loadPropertySource(extensionAttributes, propertySourceName);
            if (propertySource instanceof EnumerablePropertySource) {
                EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
                for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                    Object propertyValue = propertySource.getProperty(propertyName);
                    defaultProperties.put(propertyName, propertyValue);
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private PropertySourceExtensionAttributes<ResourcePropertySource> buildExtensionAttributes(AnnotationAttributes attributes) {
        return new PropertySourceExtensionAttributes<ResourcePropertySource>((Map<String, Object>)attributes, ResourcePropertySource.class, (PropertyResolver)this.getEnvironment());
    }

    private ResourcePropertySourceLoader getDelegate() {
        ResourcePropertySourceLoader delegate = new ResourcePropertySourceLoader();
        delegate.setEnvironment((Environment)this.getEnvironment());
        delegate.setBeanFactory((BeanFactory)this.getBeanFactory());
        delegate.setResourceLoader(this.getResourceLoader());
        delegate.setBeanClassLoader(this.getClassLoader());
        return delegate;
    }
}

