/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.context.annotation;

import io.microsphere.spring.core.annotation.ResolvablePlaceholderAnnotationAttributes;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertySourceFactory;

public class PropertySourceExtensionAttributes<A extends Annotation>
extends ResolvablePlaceholderAnnotationAttributes<A> {
    public PropertySourceExtensionAttributes(Map<String, Object> another, Class<A> annotationType, @Nullable PropertyResolver propertyResolver) {
        super(another, annotationType, propertyResolver);
    }

    public final String getName() {
        return this.getString("name");
    }

    public final boolean isAutoRefreshed() {
        return Boolean.TRUE.equals(this.get("autoRefreshed"));
    }

    public final boolean isFirstPropertySource() {
        return this.getBoolean("first");
    }

    public final String getBeforePropertySourceName() {
        return this.getString("before");
    }

    public final String getAfterPropertySourceName() {
        return this.getString("after");
    }

    public final Class<A> getAnnotationType() {
        return this.annotationType();
    }

    public final String[] getValue() {
        return this.getStringArray("value");
    }

    public final Class<? extends Comparator<Resource>> getResourceComparatorClass() {
        return this.getClass("resourceComparator");
    }

    public final boolean isIgnoreResourceNotFound() {
        return this.getBoolean("ignoreResourceNotFound");
    }

    public final String getEncoding() {
        return this.getString("encoding");
    }

    public final Class<? extends PropertySourceFactory> getPropertySourceFactoryClass() {
        return this.getClass("factory");
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("@").append(this.getAnnotationType().getName()).append("(");
        for (Map.Entry entry : this.entrySet()) {
            String name = (String)entry.getKey();
            Object value = entry.getValue();
            boolean isStringValue = value instanceof String;
            stringBuilder.append(name).append('=');
            if (isStringValue) {
                stringBuilder.append('\"');
            }
            stringBuilder.append(value);
            if (isStringValue) {
                stringBuilder.append('\"');
            }
            stringBuilder.append(',');
        }
        stringBuilder.setCharAt(stringBuilder.length() - 1, ')');
        return stringBuilder.toString();
    }
}

