/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.config.env.event;

import io.microsphere.spring.config.env.event.PropertySourceChangedEvent;
import io.microsphere.spring.core.env.PropertySourcesUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.core.env.PropertySource;

public class PropertySourcesChangedEvent
extends ApplicationContextEvent {
    private final List<PropertySourceChangedEvent> subEvents;

    public PropertySourcesChangedEvent(ApplicationContext source, PropertySourceChangedEvent ... subEvents) {
        this(source, Arrays.asList(subEvents));
    }

    public PropertySourcesChangedEvent(ApplicationContext source, List<PropertySourceChangedEvent> subEvents) {
        super(source);
        this.subEvents = subEvents;
    }

    public List<PropertySourceChangedEvent> getSubEvents() {
        return Collections.unmodifiableList(this.subEvents);
    }

    @Nonnull
    public Map<String, Object> getChangedProperties() {
        return this.getProperties(PropertySourceChangedEvent::getNewPropertySource, PropertySourcesUtils::getProperties, PropertySourceChangedEvent.Kind.ADDED, PropertySourceChangedEvent.Kind.REPLACED);
    }

    @Nonnull
    public Map<String, Object> getAddedProperties() {
        return this.getProperties(PropertySourceChangedEvent::getNewPropertySource, PropertySourcesUtils::getProperties, PropertySourceChangedEvent.Kind.ADDED);
    }

    @Nonnull
    public Map<String, Object> getRemovedProperties() {
        return this.getProperties(PropertySourceChangedEvent::getOldPropertySource, PropertySourcesUtils::getProperties, PropertySourceChangedEvent.Kind.REMOVED);
    }

    protected Map<String, Object> getProperties(Function<PropertySourceChangedEvent, PropertySource> propertySourceGetter, Function<PropertySource, Map<String, Object>> propertiesGenerator, PropertySourceChangedEvent.Kind ... kinds) {
        int size = this.subEvents.size();
        if (size == 0) {
            return Collections.emptyMap();
        }
        Predicate<PropertySourceChangedEvent.Kind> predicate = this.findAny(kinds);
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (int i = 0; i < size; ++i) {
            PropertySourceChangedEvent event = this.subEvents.get(i);
            if (!predicate.test(event.getKind())) continue;
            PropertySource propertySource = propertySourceGetter.apply(event);
            Map<String, Object> subProperties = propertiesGenerator.apply(propertySource);
            for (Map.Entry<String, Object> entry : subProperties.entrySet()) {
                String propertyName = entry.getKey();
                properties.computeIfAbsent(propertyName, k -> entry.getValue());
            }
        }
        return Collections.unmodifiableMap(properties);
    }

    private Predicate<PropertySourceChangedEvent.Kind> findAny(PropertySourceChangedEvent.Kind ... kinds) {
        return kind -> Arrays.binarySearch((Object[])kinds, kind) > -1;
    }
}

