/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.util.BaseUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ClassUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.SpringVersion;

public abstract class ApplicationContextUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationContextUtils.class);
    public static final String APPLICATION_CONTEXT_AWARE_PROCESSOR_CLASS_NAME = "org.springframework.context.support.ApplicationContextAwareProcessor";
    public static final Class<?> APPLICATION_CONTEXT_AWARE_PROCESSOR_CLASS = ClassLoaderUtils.resolveClass((String)"org.springframework.context.support.ApplicationContextAwareProcessor");

    public static ConfigurableApplicationContext asConfigurableApplicationContext(ApplicationContext context) {
        return (ConfigurableApplicationContext)ClassUtils.cast((Object)context, ConfigurableApplicationContext.class);
    }

    public static ApplicationContext asApplicationContext(BeanFactory beanFactory) {
        return (ApplicationContext)ClassUtils.cast((Object)beanFactory, ApplicationContext.class);
    }

    @Nonnull
    public static BeanPostProcessor getApplicationContextAwareProcessor(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        return ApplicationContextUtils.getApplicationContextAwareProcessor((BeanFactory)beanFactory);
    }

    @Nullable
    public static BeanPostProcessor getApplicationContextAwareProcessor(BeanFactory beanFactory) {
        List<BeanPostProcessor> beanPostProcessors = BeanFactoryUtils.getBeanPostProcessors(beanFactory);
        BeanPostProcessor applicationContextAwareProcessor = null;
        for (BeanPostProcessor beanPostProcessor : beanPostProcessors) {
            if (!beanPostProcessor.getClass().equals(APPLICATION_CONTEXT_AWARE_PROCESSOR_CLASS)) continue;
            applicationContextAwareProcessor = beanPostProcessor;
            break;
        }
        if (applicationContextAwareProcessor == null && logger.isWarnEnabled()) {
            logger.warn("The BeanPostProcessor[class : '{}' , present : {}] was not added in the BeanFactory[{}] @ Spring Framework '{}'", new Object[]{APPLICATION_CONTEXT_AWARE_PROCESSOR_CLASS_NAME, APPLICATION_CONTEXT_AWARE_PROCESSOR_CLASS != null, beanFactory, SpringVersion.getVersion()});
        }
        return applicationContextAwareProcessor;
    }
}

