/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.annotation;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.BaseUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.SingletonBeanRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.context.annotation.AnnotatedBeanDefinitionReader;
import org.springframework.context.annotation.AnnotationBeanNameGenerator;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public abstract class AnnotatedBeanDefinitionRegistryUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedBeanDefinitionRegistryUtils.class);

    public static boolean isPresentBean(BeanDefinitionRegistry registry, Class<?> annotatedClass) {
        boolean present = false;
        String[] beanNames = registry.getBeanDefinitionNames();
        ClassLoader classLoader = annotatedClass.getClassLoader();
        for (String beanName : beanNames) {
            AnnotatedBeanDefinition annotatedBeanDefinition;
            AnnotationMetadata annotationMetadata;
            String className;
            Class targetClass;
            BeanDefinition beanDefinition = registry.getBeanDefinition(beanName);
            if (!(beanDefinition instanceof AnnotatedBeanDefinition) || !(present = ObjectUtils.nullSafeEquals((Object)(targetClass = ClassUtils.resolveClassName((String)(className = (annotationMetadata = (annotatedBeanDefinition = (AnnotatedBeanDefinition)beanDefinition).getMetadata()).getClassName()), (ClassLoader)classLoader)), annotatedClass))) continue;
            if (!logger.isTraceEnabled()) break;
            logger.trace("The annotatedClass[class : '{}' , bean name : '{}'] was present in registry : {}", new Object[]{className, beanName, registry});
            break;
        }
        return present;
    }

    public static void registerBeans(BeanDefinitionRegistry registry, Class<?> ... annotatedClasses) {
        if (ArrayUtils.isEmpty((Object[])annotatedClasses)) {
            return;
        }
        LinkedHashSet classesToRegister = new LinkedHashSet(Arrays.asList(annotatedClasses));
        Iterator iterator = classesToRegister.iterator();
        while (iterator.hasNext()) {
            Class annotatedClass = (Class)iterator.next();
            if (!AnnotatedBeanDefinitionRegistryUtils.isPresentBean(registry, annotatedClass)) continue;
            iterator.remove();
        }
        AnnotatedBeanDefinitionReader reader = new AnnotatedBeanDefinitionReader(registry);
        if (logger.isTraceEnabled()) {
            logger.trace(registry.getClass().getSimpleName() + " will register annotated classes : " + Arrays.asList(annotatedClasses) + " .");
        }
        reader.register(classesToRegister.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
    }

    public static int scanBasePackages(BeanDefinitionRegistry registry, String ... basePackages) {
        int count = 0;
        if (ArrayUtils.isNotEmpty((Object[])basePackages)) {
            boolean traceEnabled = logger.isTraceEnabled();
            if (traceEnabled) {
                logger.trace(registry.getClass().getSimpleName() + " will scan base packages " + Arrays.asList(basePackages) + ".");
            }
            List<String> registeredBeanNames = Arrays.asList(registry.getBeanDefinitionNames());
            ClassPathBeanDefinitionScanner classPathBeanDefinitionScanner = new ClassPathBeanDefinitionScanner(registry);
            count = classPathBeanDefinitionScanner.scan(basePackages);
            ArrayList<String> scannedBeanNames = new ArrayList<String>(count);
            scannedBeanNames.addAll(Arrays.asList(registry.getBeanDefinitionNames()));
            scannedBeanNames.removeAll(registeredBeanNames);
            if (traceEnabled) {
                logger.trace("The Scanned Components[ count : " + count + "] under base packages " + Arrays.asList(basePackages) + " : ");
            }
            for (String scannedBeanName : scannedBeanNames) {
                BeanDefinition scannedBeanDefinition = registry.getBeanDefinition(scannedBeanName);
                if (!traceEnabled) continue;
                logger.trace("Component [ name : " + scannedBeanName + " , class : " + scannedBeanDefinition.getBeanClassName() + " ]");
            }
        }
        return count;
    }

    public static BeanNameGenerator resolveAnnotatedBeanNameGenerator(BeanDefinitionRegistry registry) {
        BeanNameGenerator beanNameGenerator = null;
        if (registry instanceof SingletonBeanRegistry) {
            SingletonBeanRegistry singletonBeanRegistry = (SingletonBeanRegistry)registry;
            beanNameGenerator = (BeanNameGenerator)singletonBeanRegistry.getSingleton("org.springframework.context.annotation.internalConfigurationBeanNameGenerator");
        }
        if (beanNameGenerator == null) {
            if (logger.isInfoEnabled()) {
                logger.info("BeanNameGenerator bean can't be found in BeanFactory with name [org.springframework.context.annotation.internalConfigurationBeanNameGenerator]");
                logger.info("BeanNameGenerator will be a instance of " + AnnotationBeanNameGenerator.class.getName() + " , it maybe a potential problem on bean name generation.");
            }
            beanNameGenerator = new AnnotationBeanNameGenerator();
        }
        return beanNameGenerator;
    }

    public static Set<BeanDefinitionHolder> findBeanDefinitionHolders(ClassPathBeanDefinitionScanner scanner, String packageToScan, BeanDefinitionRegistry registry, BeanNameGenerator beanNameGenerator) {
        Set beanDefinitions = scanner.findCandidateComponents(packageToScan);
        LinkedHashSet<BeanDefinitionHolder> beanDefinitionHolders = new LinkedHashSet<BeanDefinitionHolder>(beanDefinitions.size());
        for (BeanDefinition beanDefinition : beanDefinitions) {
            String beanName = beanNameGenerator.generateBeanName(beanDefinition, registry);
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName);
            beanDefinitionHolders.add(beanDefinitionHolder);
        }
        return beanDefinitionHolders;
    }
}

