/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.annotation;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.core.env.EnvironmentUtils;
import io.microsphere.text.FormatUtils;
import javax.annotation.Nonnull;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;

public abstract class BeanCapableImportCandidate
implements BeanClassLoaderAware,
BeanFactoryAware,
EnvironmentAware,
ResourceLoaderAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ClassLoader classLoader;
    protected ConfigurableListableBeanFactory beanFactory;
    protected ConfigurableEnvironment environment;
    protected ResourceLoader resourceLoader;

    public final void setBeanClassLoader(ClassLoader classLoader) {
        if (this.classLoader == null) {
            this.classLoader = classLoader;
            this.assertImportCandidate();
        }
    }

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.beanFactory == null) {
            this.beanFactory = BeanFactoryUtils.asConfigurableListableBeanFactory(beanFactory);
        }
    }

    public final void setEnvironment(Environment environment) {
        if (this.environment == null) {
            this.environment = EnvironmentUtils.asConfigurableEnvironment(environment);
        }
    }

    public final void setResourceLoader(ResourceLoader resourceLoader) {
        if (this.resourceLoader == null) {
            this.resourceLoader = resourceLoader;
            this.initializeSelf();
        }
    }

    @Nonnull
    public final ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Nonnull
    public final ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    @Nonnull
    public final ConfigurableEnvironment getEnvironment() {
        return this.environment;
    }

    @Nonnull
    public final ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    private void assertImportCandidate() {
        Class<?> klass = this.getClass();
        Class<ImportSelector> interface1 = ImportSelector.class;
        Class<ImportBeanDefinitionRegistrar> interface2 = ImportBeanDefinitionRegistrar.class;
        if (!interface1.isAssignableFrom(klass) && !interface2.isAssignableFrom(klass)) {
            String message = FormatUtils.format((String)"The @Import Candidate[class : '{}'] must implement the interface '{}' or '{}'", (Object[])new Object[]{klass.getName(), interface1.getName(), interface2.getName()});
            throw new IllegalStateException(message);
        }
    }

    private void initializeSelf() {
        String beanName = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        this.beanFactory.registerSingleton(beanName, (Object)this);
        this.beanFactory.initializeBean((Object)this, beanName);
    }
}

