/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.annotation;

import io.microsphere.spring.context.annotation.EnableEventExtension;
import io.microsphere.spring.context.event.InterceptingApplicationEventMulticaster;
import io.microsphere.spring.context.event.InterceptingApplicationEventMulticasterProxy;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.StringUtils;

public class EventExtensionRegistrar
implements ImportBeanDefinitionRegistrar,
EnvironmentAware {
    private static final String ANNOTATION_CLASS_NAME = EnableEventExtension.class.getName();
    private static final String BEAN_NAME = "applicationEventMulticaster";
    private Environment environment;

    public void registerBeanDefinitions(AnnotationMetadata metadata, BeanDefinitionRegistry registry) {
        Map attributes = metadata.getAnnotationAttributes(ANNOTATION_CLASS_NAME);
        boolean intercepted = (Boolean)attributes.get("intercepted");
        String executorForListener = (String)attributes.get("executorForListener");
        this.registerApplicationEventMulticaster(intercepted, executorForListener, registry);
    }

    private void registerApplicationEventMulticaster(boolean intercepted, String executorForListener, BeanDefinitionRegistry registry) {
        if (!intercepted && "N/E".equals(executorForListener)) {
            return;
        }
        String beanName = BEAN_NAME;
        boolean associatedExecutorBean = !"N/E".equals(executorForListener);
        boolean beanExists = registry.containsBeanDefinition(beanName);
        AbstractBeanDefinition targetBeanDefinition = beanExists ? this.rebuildApplicationEventMulticasterBeanDefinition(intercepted, beanName, registry) : this.buildApplicationEventMulticasterBeanDefinition(intercepted);
        this.associateExecutorBeanIfRequired(targetBeanDefinition, associatedExecutorBean, executorForListener);
        registry.registerBeanDefinition(beanName, (BeanDefinition)targetBeanDefinition);
    }

    private AbstractBeanDefinition rebuildApplicationEventMulticasterBeanDefinition(boolean intercepted, String beanName, BeanDefinitionRegistry registry) {
        AbstractBeanDefinition targetBeanDefinition;
        BeanDefinition originalBeanDefinition = registry.getBeanDefinition(beanName);
        if (intercepted) {
            registry.removeBeanDefinition(beanName);
            String resetBeanName = InterceptingApplicationEventMulticasterProxy.getResetBeanName(this.environment);
            registry.registerBeanDefinition(resetBeanName, originalBeanDefinition);
            targetBeanDefinition = new RootBeanDefinition(InterceptingApplicationEventMulticasterProxy.class);
        } else {
            targetBeanDefinition = (AbstractBeanDefinition)originalBeanDefinition;
        }
        return targetBeanDefinition;
    }

    private AbstractBeanDefinition buildApplicationEventMulticasterBeanDefinition(boolean intercepted) {
        Class beanClass = intercepted ? InterceptingApplicationEventMulticaster.class : SimpleApplicationEventMulticaster.class;
        return new RootBeanDefinition(beanClass);
    }

    private String getExecutorBeanName(boolean associatedExecutorBean, String executorForListener) {
        return associatedExecutorBean ? executorForListener : null;
    }

    private AbstractBeanDefinition buildBeanDefinition(Class<?> beanClass, @Nullable String executorBeanName) {
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(beanClass);
        if (StringUtils.hasText((String)executorBeanName)) {
            // empty if block
        }
        return beanDefinitionBuilder.getBeanDefinition();
    }

    private void associateExecutorBeanIfRequired(AbstractBeanDefinition beanDefinition, boolean associatedExecutorBean, String executorBeanName) {
        if (associatedExecutorBean) {
            MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
            propertyValues.addPropertyValue("taskExecutor", (Object)new RuntimeBeanReference(executorBeanName));
        }
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

