/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.config.NamedBeanHolderComparator;
import io.microsphere.spring.beans.factory.support.BeanRegistrar;
import io.microsphere.spring.context.event.BeanListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.NamedBeanHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;

class BeanListeners
implements BeanListener {
    private static final Logger logger = LoggerFactory.getLogger(BeanListeners.class);
    private static final String BEAN_NAME = "beanEventListeners";
    private final List<NamedBeanHolder<BeanListener>> namedListeners;
    private final int listenerCount;
    private final Set<String> readyBeanNames;

    public BeanListeners(ConfigurableListableBeanFactory beanFactory) {
        this.namedListeners = this.getBeanListeners(beanFactory);
        this.listenerCount = this.namedListeners.size();
        this.readyBeanNames = BeanListeners.getReadyBeanNames(beanFactory);
    }

    static Set<String> getReadyBeanNames(ConfigurableListableBeanFactory beanFactory) {
        LinkedHashSet<String> readyBeanNames = new LinkedHashSet<String>();
        String[] singletonNames = beanFactory.getSingletonNames();
        readyBeanNames.addAll(Arrays.asList(singletonNames));
        return readyBeanNames;
    }

    void setReadyBeanNames(Set<String> readyBeanNames) {
        this.readyBeanNames.clear();
        this.readyBeanNames.addAll(readyBeanNames);
    }

    private List<NamedBeanHolder<BeanListener>> getBeanListeners(ConfigurableListableBeanFactory beanFactory) {
        BeanRegistrar.registerSpringFactoriesBeans((BeanFactory)beanFactory, BeanListener.class);
        Map beanEventListenersMap = beanFactory.getBeansOfType(BeanListener.class);
        ArrayList<NamedBeanHolder<BeanListener>> namedListeners = new ArrayList<NamedBeanHolder<BeanListener>>(beanEventListenersMap.size());
        for (Map.Entry entry : beanEventListenersMap.entrySet()) {
            NamedBeanHolder namedListener = new NamedBeanHolder((String)entry.getKey(), (Object)((BeanListener)entry.getValue()));
            namedListeners.add((NamedBeanHolder<BeanListener>)namedListener);
        }
        namedListeners.sort(NamedBeanHolderComparator.INSTANCE);
        return namedListeners;
    }

    @Override
    public boolean supports(String beanName) {
        return true;
    }

    @Override
    public void onBeanDefinitionReady(String beanName, RootBeanDefinition mergedBeanDefinition) {
        this.iterate(beanName, listener -> listener.onBeanDefinitionReady(beanName, mergedBeanDefinition), "onBeanDefinitionReady");
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition) {
        this.iterate(beanName, listener -> listener.onBeforeBeanInstantiate(beanName, mergedBeanDefinition), "onBeforeBeanInstantiate");
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition, Constructor<?> constructor, Object[] args) {
        this.iterate(beanName, listener -> listener.onBeforeBeanInstantiate(beanName, mergedBeanDefinition, constructor, args), "onBeforeBeanInstantiate");
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition, Object factoryBean, Method factoryMethod, Object[] args) {
        this.iterate(beanName, listener -> listener.onBeforeBeanInstantiate(beanName, mergedBeanDefinition, factoryBean, factoryMethod, args), "onBeforeBeanInstantiate");
    }

    @Override
    public void onAfterBeanInstantiated(String beanName, RootBeanDefinition mergedBeanDefinition, Object bean) {
        this.iterate(beanName, listener -> listener.onAfterBeanInstantiated(beanName, mergedBeanDefinition, bean), "onAfterBeanInstantiated");
    }

    @Override
    public void onBeanPropertyValuesReady(String beanName, Object bean, PropertyValues pvs) {
        this.iterate(beanName, listener -> listener.onBeanPropertyValuesReady(beanName, bean, pvs), "onBeanPropertyValuesReady");
    }

    @Override
    public void onBeforeBeanInitialize(String beanName, Object bean) {
        this.iterate(beanName, listener -> listener.onBeforeBeanInitialize(beanName, bean), "onBeforeBeanInitialize");
    }

    @Override
    public void onAfterBeanInitialized(String beanName, Object bean) {
        this.iterate(beanName, listener -> listener.onAfterBeanInitialized(beanName, bean), "onAfterBeanInitialized");
    }

    @Override
    public void onBeanReady(String beanName, Object bean) {
        this.iterate(beanName, listener -> listener.onBeanReady(beanName, bean), "onBeanReady");
    }

    @Override
    public void onBeforeBeanDestroy(String beanName, Object bean) {
        this.iterate(beanName, listener -> listener.onBeforeBeanDestroy(beanName, bean), "onBeforeBeanDestroy");
    }

    @Override
    public void onAfterBeanDestroy(String beanName, Object bean) {
        this.iterate(beanName, listener -> listener.onAfterBeanDestroy(beanName, bean), "onAfterBeanDestroy");
    }

    private void iterate(String beanName, Consumer<BeanListener> listenerConsumer, String action) {
        if (this.isIgnored(beanName)) {
            return;
        }
        for (int i = 0; i < this.listenerCount; ++i) {
            NamedBeanHolder<BeanListener> namedListener = this.namedListeners.get(i);
            BeanListener listener = (BeanListener)namedListener.getBeanInstance();
            String listenerBeanName = namedListener.getBeanName();
            try {
                if (!listener.supports(beanName)) continue;
                listenerConsumer.accept(listener);
                logger.trace("BeanEventListener[name : '{}' , bean : '{}', order : {}] execution {} -> '{}'", new Object[]{listenerBeanName, listener, i, beanName, action});
                continue;
            }
            catch (Throwable e) {
                logger.error("BeanEventListener[name : '{}' , bean : '{}', order : {}] execution {} -> '{}' failed", new Object[]{listenerBeanName, listener, i, beanName, action, e});
            }
        }
    }

    private boolean isIgnored(String beanName) {
        return this.readyBeanNames.contains(beanName) || BEAN_NAME.equals(beanName);
    }

    void registerBean(BeanDefinitionRegistry registry) {
        BeanRegistrar.registerFactoryBean(registry, BEAN_NAME, this);
    }

    static BeanListeners getBean(BeanFactory beanFactory) {
        return (BeanListeners)beanFactory.getBean(BEAN_NAME, BeanListeners.class);
    }
}

