/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.context.event.BeanListener;
import io.microsphere.util.StopWatch;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.StringJoiner;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class BeanTimeStatistics
implements BeanListener,
BeanNameAware {
    private final StopWatch stopWatch = new StopWatch("spring.context.beans");
    private String beanName;

    @Override
    public boolean supports(String beanName) {
        return !this.isIgnoredBean(beanName);
    }

    @Override
    public void onBeanDefinitionReady(String beanName, RootBeanDefinition mergedBeanDefinition) {
        if (this.isIgnoredBean(beanName)) {
            return;
        }
        this.stopWatch.start("ready." + beanName);
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition) {
        this.stopWatch.start("instantiation." + beanName);
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition, Constructor<?> constructor, Object[] args) {
        this.stopWatch.start("instantiation." + beanName);
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition, Object factoryBean, Method factoryMethod, Object[] args) {
        this.stopWatch.start("instantiation." + beanName);
    }

    @Override
    public void onAfterBeanInstantiated(String beanName, RootBeanDefinition mergedBeanDefinition, Object bean) {
        this.stopWatch.stop();
    }

    @Override
    public void onBeanPropertyValuesReady(String beanName, Object bean, PropertyValues pvs) {
    }

    @Override
    public void onBeforeBeanInitialize(String beanName, Object bean) {
        this.stopWatch.start("initialization." + beanName);
    }

    @Override
    public void onAfterBeanInitialized(String beanName, Object bean) {
        this.stopWatch.stop();
    }

    @Override
    public void onBeanReady(String beanName, Object bean) {
        if (this.isIgnoredBean(beanName)) {
            return;
        }
        this.stopWatch.stop();
    }

    @Override
    public void onBeforeBeanDestroy(String beanName, Object bean) {
        this.stopWatch.start("destroy." + beanName);
    }

    @Override
    public void onAfterBeanDestroy(String beanName, Object bean) {
        this.stopWatch.stop();
    }

    public StopWatch getStopWatch() {
        return this.stopWatch;
    }

    public String toString() {
        return new StringJoiner(", ", BeanTimeStatistics.class.getSimpleName() + "[", "]").add(this.stopWatch.toString()).toString();
    }

    private boolean isIgnoredBean(String beanName) {
        return Objects.equals(this.beanName, beanName);
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }
}

