/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.context.event.ApplicationListenerInterceptor;
import io.microsphere.spring.context.event.ApplicationListenerInterceptorChain;
import java.util.Iterator;
import java.util.function.BiConsumer;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

class DefaultApplicationListenerInterceptorChain
implements ApplicationListenerInterceptorChain {
    private final Iterator<ApplicationListenerInterceptor> iterator;
    private final BiConsumer<ApplicationListener<?>, ApplicationEvent> listenerAndEventConsumer;

    public DefaultApplicationListenerInterceptorChain(Iterable<ApplicationListenerInterceptor> interceptors, BiConsumer<ApplicationListener<?>, ApplicationEvent> listenerAndEventConsumer) {
        this.iterator = interceptors.iterator();
        this.listenerAndEventConsumer = listenerAndEventConsumer;
    }

    @Override
    public void intercept(ApplicationListener<?> applicationListener, ApplicationEvent event) {
        if (this.iterator.hasNext()) {
            ApplicationListenerInterceptor interceptor = this.iterator.next();
            interceptor.intercept(applicationListener, event, this);
            return;
        }
        this.listenerAndEventConsumer.accept(applicationListener, event);
    }
}

