/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.collection.ListUtils;
import io.microsphere.filter.Filter;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.filter.ResolvableDependencyTypeFilter;
import io.microsphere.spring.context.event.BeanFactoryListenerAdapter;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.beans.factory.config.SmartInstantiationAwareBeanPostProcessor;
import org.springframework.beans.factory.support.AutowireCandidateResolver;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodParameter;
import org.springframework.util.ObjectUtils;

public class DependencyAnalysisBeanFactoryListener
implements BeanFactoryListenerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(DependencyAnalysisBeanFactoryListener.class);

    @Override
    public void onBeanFactoryConfigurationFrozen(ConfigurableListableBeanFactory bf) {
        DefaultListableBeanFactory beanFactory = BeanFactoryUtils.asDefaultListableBeanFactory(bf);
        ResolvableDependencyTypeFilter resolvableDependencyTypeFilter = new ResolvableDependencyTypeFilter(beanFactory);
        List<BeanDefinitionHolder> beanDefinitionHolders = this.getNonLazyInitSingletonMergedBeanDefinitionHolders(bf);
        int beansCount = beanDefinitionHolders.size();
        HashMap<String, Set<String>> dependentBeanNamesMap = new HashMap<String, Set<String>>(beansCount);
        for (int i = 0; i < beansCount; ++i) {
            BeanDefinitionHolder beanDefinitionHolder = beanDefinitionHolders.get(i);
            Set<String> dependentBeanNames = this.resolveDependentBeanNames(beanDefinitionHolder, resolvableDependencyTypeFilter, beanDefinitionHolders, beanFactory);
            dependentBeanNamesMap.put(beanDefinitionHolder.getBeanName(), dependentBeanNames);
        }
        this.flattenDependentBeanNamesMap(dependentBeanNamesMap);
    }

    private void flattenDependentBeanNamesMap(Map<String, Set<String>> dependentBeanNamesMap) {
        LinkedHashMap<String, Set<String>> dependenciesMap = new LinkedHashMap<String, Set<String>>(dependentBeanNamesMap.size());
        for (Map.Entry<String, Set<String>> entry : dependentBeanNamesMap.entrySet()) {
            Set<String> dependentBeanNames = entry.getValue();
            if (dependentBeanNames.isEmpty()) continue;
            String beanName = entry.getKey();
            LinkedHashSet<String> flattenDependentBeanNames = new LinkedHashSet<String>(dependentBeanNames.size() * 2);
            this.flatDependentBeanNames(beanName, dependentBeanNamesMap, dependenciesMap, flattenDependentBeanNames);
            entry.setValue(flattenDependentBeanNames);
        }
        for (Map.Entry<String, Set<String>> entry : dependenciesMap.entrySet()) {
            String dependentBeanName = entry.getKey();
            dependentBeanNamesMap.remove(dependentBeanName);
            this.logDependenciesTrace(dependentBeanName, entry);
        }
        this.logDependentTrace(dependentBeanNamesMap);
    }

    private void logDependenciesTrace(String dependentBeanName, Map.Entry<String, Set<String>> dependencies) {
        if (logger.isTraceEnabled()) {
            logger.trace("The bean dependency : '{}' -> beans : {}", new Object[]{dependentBeanName, dependencies.getValue()});
        }
    }

    private void logDependentTrace(Map<String, Set<String>> dependentBeanNamesMap) {
        if (logger.isTraceEnabled()) {
            for (Map.Entry<String, Set<String>> entry : dependentBeanNamesMap.entrySet()) {
                logger.trace("The bean : '{}' <- bean dependencies : {}", new Object[]{entry.getKey(), entry.getValue()});
            }
        }
    }

    private void flatDependentBeanNames(String beanName, Map<String, Set<String>> dependentBeanNamesMap, Map<String, Set<String>> dependenciesMap, Set<String> flattenDependentBeanNames) {
        Set<String> dependentBeanNames = this.retrieveDependentBeanNames(beanName, dependentBeanNamesMap);
        if (dependentBeanNames.isEmpty()) {
            return;
        }
        for (String dependentBeanName : dependentBeanNames) {
            Set dependencies = dependenciesMap.computeIfAbsent(dependentBeanName, k -> new LinkedHashSet());
            dependencies.add(beanName);
            flattenDependentBeanNames.add(dependentBeanName);
            this.flatDependentBeanNames(dependentBeanName, dependentBeanNamesMap, dependenciesMap, flattenDependentBeanNames);
        }
    }

    private Set<String> retrieveDependentBeanNames(String beanName, Map<String, Set<String>> dependentBeanNamesMap) {
        Set<String> dependentBeanNames = dependentBeanNamesMap.get(beanName);
        if (dependentBeanNames == null) {
            dependentBeanNames = Collections.emptySet();
        } else {
            dependentBeanNames.remove(beanName);
        }
        return dependentBeanNames;
    }

    private Set<String> resolveDependentBeanNames(BeanDefinitionHolder beanDefinitionHolder, Filter<Class<?>> resolvableDependencyTypeFilter, List<BeanDefinitionHolder> beanDefinitionHolders, DefaultListableBeanFactory beanFactory) {
        String beanName = beanDefinitionHolder.getBeanName();
        RootBeanDefinition beanDefinition = (RootBeanDefinition)beanDefinitionHolder.getBeanDefinition();
        LinkedHashSet<String> dependentBeanNames = new LinkedHashSet<String>();
        List<String> beanDefinitionDependentBeanNames = this.resolveBeanDefinitionDependentBeanNames(beanDefinition);
        List<String> parameterDependentBeanNames = this.resolveParameterDependentBeanNames(beanName, beanDefinition, resolvableDependencyTypeFilter, beanDefinitionHolders, beanFactory);
        List<String> injectedBeanNames = this.resolveInjectionDependentBeanNames(beanName, beanDefinition, resolvableDependencyTypeFilter, beanDefinitionHolder, beanFactory);
        dependentBeanNames.addAll(beanDefinitionDependentBeanNames);
        dependentBeanNames.addAll(parameterDependentBeanNames);
        dependentBeanNames.addAll(injectedBeanNames);
        dependentBeanNames.remove(beanName);
        this.removeInitializedBeanNames(dependentBeanNames, beanFactory);
        return dependentBeanNames;
    }

    private List<String> resolveInjectionDependentBeanNames(String beanName, RootBeanDefinition beanDefinition, Filter<Class<?>> resolvableDependencyTypeFilter, BeanDefinitionHolder beanDefinitionHolder, DefaultListableBeanFactory beanFactory) {
        LinkedList injectedBeanNames = ListUtils.newLinkedList();
        return injectedBeanNames;
    }

    private void removeInitializedBeanNames(Set<String> dependentBeanNames, DefaultListableBeanFactory beanFactory) {
        if (dependentBeanNames.isEmpty()) {
            return;
        }
        Iterator<String> iterator = dependentBeanNames.iterator();
        while (iterator.hasNext()) {
            String dependentBeanName = iterator.next();
            if (!beanFactory.containsSingleton(dependentBeanName)) continue;
            iterator.remove();
        }
    }

    private List<String> resolveBeanDefinitionDependentBeanNames(RootBeanDefinition beanDefinition) {
        List<String> dependsOnBeanNames = this.getDependsOnBeanNames(beanDefinition);
        List<String> refBeanNames = this.getRefBeanNames(beanDefinition);
        int size = dependsOnBeanNames.size() + refBeanNames.size();
        if (size < 1) {
            return Collections.emptyList();
        }
        ArrayList dependentBeanNames = ListUtils.newArrayList((int)size);
        dependentBeanNames.addAll(dependsOnBeanNames);
        dependentBeanNames.addAll(refBeanNames);
        return dependentBeanNames;
    }

    private List<String> getDependsOnBeanNames(RootBeanDefinition beanDefinition) {
        Object[] dependsOn = beanDefinition.getDependsOn();
        return ObjectUtils.isEmpty((Object[])dependsOn) ? Collections.emptyList() : Arrays.asList(dependsOn);
    }

    private List<String> getRefBeanNames(RootBeanDefinition beanDefinition) {
        MutablePropertyValues mutablePropertyValues = beanDefinition.getPropertyValues();
        PropertyValue[] propertyValues = mutablePropertyValues.getPropertyValues();
        int propertyValuesLength = propertyValues.length;
        if (propertyValuesLength < 1) {
            return Collections.emptyList();
        }
        LinkedList dependentBeanNames = ListUtils.newLinkedList();
        for (int i = 0; i < propertyValuesLength; ++i) {
            PropertyValue propertyValue = propertyValues[i];
            Object value = propertyValue.getValue();
            if (!(value instanceof BeanReference)) continue;
            BeanReference beanReference = (BeanReference)value;
            String beanName = beanReference.getBeanName();
            dependentBeanNames.add(beanName);
        }
        return dependentBeanNames;
    }

    private List<String> resolveParameterDependentBeanNames(String beanName, RootBeanDefinition beanDefinition, Filter<Class<?>> resolvableDependencyTypeFilter, List<BeanDefinitionHolder> beanDefinitionHolders, DefaultListableBeanFactory beanFactory) {
        Parameter[] parameters = this.getParameters(beanName, beanDefinition, beanFactory);
        int parametersLength = parameters.length;
        if (parametersLength < 1) {
            return Collections.emptyList();
        }
        ArrayList dependentBeanNames = ListUtils.newArrayList((int)parametersLength);
        for (int i = 0; i < parametersLength; ++i) {
            Parameter parameter = parameters[i];
            Class<?> dependentType = this.resolveDependentType(parameter);
            if (resolvableDependencyTypeFilter.accept(dependentType)) continue;
            List<String> beanNames = this.resolveDependentBeanNames(parameter, dependentType, beanFactory);
            dependentBeanNames.addAll(beanNames);
        }
        return dependentBeanNames;
    }

    private List<String> resolveDependentBeanNames(Parameter parameter, Class<?> dependentType, DefaultListableBeanFactory beanFactory) {
        String dependentBeanName = this.resolveSuggestedDependentBeanName(parameter, beanFactory);
        if (dependentBeanName == null) {
            String[] beanNames = beanFactory.getBeanNamesForType(dependentType, false, false);
            return Arrays.asList(beanNames);
        }
        return Collections.singletonList(dependentBeanName);
    }

    private String resolveSuggestedDependentBeanName(Parameter parameter, DefaultListableBeanFactory beanFactory) {
        String value;
        AutowireCandidateResolver autowireCandidateResolver = beanFactory.getAutowireCandidateResolver();
        if (autowireCandidateResolver == null) {
            return null;
        }
        DependencyDescriptor dependencyDescriptor = new DependencyDescriptor(MethodParameter.forParameter((Parameter)parameter), true, false);
        Object suggestedValue = autowireCandidateResolver.getSuggestedValue(dependencyDescriptor);
        return suggestedValue instanceof String ? (value = (String)suggestedValue) : null;
    }

    private Class<?> resolveDependentType(Parameter parameter) {
        List arguments;
        int argumentsSize;
        Class parameterRawType;
        Type parameterType = parameter.getParameterizedType();
        Class dependentType = parameterRawType = parameter.getType();
        if (TypeUtils.isParameterizedType((Object)parameterType) && (argumentsSize = (arguments = TypeUtils.resolveActualTypeArgumentClasses((Type)parameterType, parameterRawType)).size()) > 0) {
            dependentType = (Class)arguments.get(argumentsSize - 1);
        }
        return dependentType;
    }

    private Parameter[] getParameters(String beanName, RootBeanDefinition beanDefinition, DefaultListableBeanFactory beanFactory) {
        Method factoryMethod = beanDefinition.getResolvedFactoryMethod();
        Parameter[] parameters = null;
        if (factoryMethod == null) {
            Class<?> beanClass = this.getBeanClass(beanDefinition, beanFactory.getBeanClassLoader());
            Constructor[] constructors = this.resolveConstructors(beanName, beanClass, (ConfigurableListableBeanFactory)beanFactory);
            int constructorsLength = constructors.length;
            if (constructorsLength != 1) {
                logger.warn("Why the Bean[name : '{}' , class : {} ] has {} constructors?", new Object[]{beanName, beanClass, constructorsLength});
                parameters = ArrayUtils.EMPTY_PARAMETER_ARRAY;
            } else {
                Constructor constructor = constructors[0];
                parameters = constructor.getParameters();
            }
        } else {
            parameters = factoryMethod.getParameters();
        }
        return parameters;
    }

    private List<BeanDefinitionHolder> getNonLazyInitSingletonMergedBeanDefinitionHolders(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNames = beanFactory.getBeanDefinitionNames();
        int beansCount = beanNames.length;
        ArrayList beanDefinitionHolders = ListUtils.newArrayList((int)beansCount);
        for (int i = 0; i < beansCount; ++i) {
            String beanName = beanNames[i];
            if (beanFactory.containsSingleton(beanName)) {
                logger.trace("The Bean[name : '{}'] is ready", new Object[]{beanName});
                continue;
            }
            BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
            if (!this.isEligibleBeanDefinition(beanDefinition)) continue;
            String[] aliases = beanFactory.getAliases(beanName);
            BeanDefinitionHolder beanDefinitionHolder = new BeanDefinitionHolder(beanDefinition, beanName, aliases);
            beanDefinitionHolders.add(beanDefinitionHolder);
        }
        return beanDefinitionHolders;
    }

    private Constructor[] resolveConstructors(String beanName, Class<?> beanClass, ConfigurableListableBeanFactory beanFactory) {
        Object[] constructors = null;
        if (!beanClass.isInterface()) {
            SmartInstantiationAwareBeanPostProcessor processor;
            List<SmartInstantiationAwareBeanPostProcessor> processors = this.getSmartInstantiationAwareBeanPostProcessors(beanFactory);
            Iterator<SmartInstantiationAwareBeanPostProcessor> iterator = processors.iterator();
            while (iterator.hasNext() && (constructors = (processor = iterator.next()).determineCandidateConstructors(beanClass, beanName)) == null) {
            }
        }
        constructors = ObjectUtils.isEmpty(constructors) ? beanClass.getConstructors() : constructors;
        constructors = ObjectUtils.isEmpty((Object[])constructors) ? beanClass.getDeclaredConstructors() : constructors;
        return constructors;
    }

    private List<SmartInstantiationAwareBeanPostProcessor> getSmartInstantiationAwareBeanPostProcessors(ConfigurableListableBeanFactory beanFactory) {
        if (beanFactory instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory dbf = (DefaultListableBeanFactory)beanFactory;
            LinkedList<SmartInstantiationAwareBeanPostProcessor> processors = new LinkedList<SmartInstantiationAwareBeanPostProcessor>();
            List beanPostProcessors = dbf.getBeanPostProcessors();
            for (BeanPostProcessor beanPostProcessor : beanPostProcessors) {
                if (!(beanPostProcessor instanceof SmartInstantiationAwareBeanPostProcessor)) continue;
                SmartInstantiationAwareBeanPostProcessor siaBeanProcessor = (SmartInstantiationAwareBeanPostProcessor)beanPostProcessor;
                processors.add(siaBeanProcessor);
            }
            return processors;
        }
        return Collections.emptyList();
    }

    private Class<?> getBeanClass(RootBeanDefinition beanDefinition, @Nullable ClassLoader classLoader) {
        return beanDefinition.hasBeanClass() ? beanDefinition.getBeanClass() : ClassLoaderUtils.resolveClass((String)beanDefinition.getBeanClassName(), (ClassLoader)classLoader);
    }

    private boolean isEligibleBeanDefinition(BeanDefinition beanDefinition) {
        if (beanDefinition != null && beanDefinition.isSingleton() && !beanDefinition.isLazyInit() && beanDefinition instanceof RootBeanDefinition) {
            RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
            Supplier instanceSupplier = rootBeanDefinition.getInstanceSupplier();
            return instanceSupplier == null || instanceSupplier.get() == null;
        }
        return false;
    }
}

