/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import io.microsphere.spring.context.event.BeanFactoryListeners;
import io.microsphere.spring.context.event.BeanListeners;
import io.microsphere.spring.context.event.GenericApplicationListenerAdapter;
import io.microsphere.util.ClassLoaderUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.ResolvableType;
import org.springframework.util.ReflectionUtils;

class EventPublishingBeanAfterProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements GenericApplicationListenerAdapter {
    private static final Class<?> DISPOSABLE_BEAN_ADAPTER_CLASS = ClassLoaderUtils.resolveClass((String)"org.springframework.beans.factory.support.DisposableBeanAdapter");
    private final ConfigurableApplicationContext context;
    private final BeanListeners beanEventListeners;

    public EventPublishingBeanAfterProcessor(ConfigurableApplicationContext context) {
        this.context = context;
        this.beanEventListeners = BeanListeners.getBean((BeanFactory)context);
    }

    @Override
    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.beanEventListeners.onAfterBeanInitialized(beanName, bean);
        return bean;
    }

    @Override
    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return ContextRefreshedEvent.class.isAssignableFrom(eventType) || ContextClosedEvent.class.isAssignableFrom(eventType);
    }

    public boolean supportsEventType(ResolvableType eventType) {
        return eventType.isAssignableFrom(ContextRefreshedEvent.class) || eventType.isAssignableFrom(ContextClosedEvent.class);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (!Objects.equals(this.context, event.getSource())) {
            return;
        }
        if (event instanceof ContextRefreshedEvent) {
            ContextRefreshedEvent contextRefreshedEvent = (ContextRefreshedEvent)event;
            this.onContextRefreshedEvent(contextRefreshedEvent);
        } else if (event instanceof ContextClosedEvent) {
            ContextClosedEvent contextClosedEvent = (ContextClosedEvent)event;
            this.onContextClosedEvent(contextClosedEvent);
        }
    }

    private void onContextRefreshedEvent(ContextRefreshedEvent event) {
        this.fireBeansReadyEvent();
    }

    private void fireBeansReadyEvent() {
        ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
        Map beansMap = beanFactory.getBeansOfType(Object.class, true, false);
        for (Map.Entry beanEntry : beansMap.entrySet()) {
            String beanName = (String)beanEntry.getKey();
            Object bean = beanEntry.getValue();
            this.fireBeanReadyEvent(beanName, bean);
        }
    }

    private void fireBeanReadyEvent(String beanName, Object bean) {
        this.beanEventListeners.onBeanReady(beanName, bean);
    }

    private void onContextClosedEvent(ContextClosedEvent event) {
        this.decorateDisposableBeans();
    }

    private void decorateDisposableBeans() {
        ConfigurableListableBeanFactory beanFactory = this.context.getBeanFactory();
        if (beanFactory instanceof DefaultSingletonBeanRegistry) {
            ReflectionUtils.doWithFields(DefaultSingletonBeanRegistry.class, field -> {
                field.setAccessible(true);
                Map disposableBeans = (Map)field.get(beanFactory);
                for (Map.Entry entry : disposableBeans.entrySet()) {
                    String beanName = (String)entry.getKey();
                    Object adapterBean = entry.getValue();
                    if (!this.isDisposableBeanAdapter(adapterBean)) continue;
                    DisposableBean delegate = (DisposableBean)adapterBean;
                    DecoratingDisposableBean decoratingDisposableBean = new DecoratingDisposableBean(beanName, delegate, this.beanEventListeners::onAfterBeanDestroy);
                    entry.setValue(decoratingDisposableBean);
                }
            }, field -> "disposableBeans".equals(field.getName()) && Map.class.isAssignableFrom(field.getType()));
        }
    }

    private boolean isDisposableBeanAdapter(Object bean) {
        return DISPOSABLE_BEAN_ADAPTER_CLASS.equals(bean.getClass()) && bean instanceof DisposableBean;
    }

    private static class DecoratingDisposableBean
    implements DisposableBean {
        private final String beanName;
        private final DisposableBean delegate;
        private final BiConsumer<String, Object> destroyedCallback;

        DecoratingDisposableBean(String beanName, DisposableBean delegate, BiConsumer<String, Object> destroyedCallback) {
            this.beanName = beanName;
            this.delegate = delegate;
            this.destroyedCallback = destroyedCallback;
        }

        public void destroy() throws Exception {
            this.delegate.destroy();
            ReflectionUtils.doWithFields(DISPOSABLE_BEAN_ADAPTER_CLASS, field -> {
                field.setAccessible(true);
                Object bean = field.get(this.delegate);
                this.destroyedCallback.accept(this.beanName, bean);
            }, field -> "bean".equals(field.getName()) && Object.class.equals(field.getType()));
        }
    }

    static class Initializer {
        public Initializer(ConfigurableApplicationContext context) {
            EventPublishingBeanAfterProcessor processor = new EventPublishingBeanAfterProcessor(context);
            ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
            beanFactory.addBeanPostProcessor((BeanPostProcessor)processor);
            context.addApplicationListener((ApplicationListener)processor);
            this.fireBeanFactoryConfigurationFrozenEvent(beanFactory);
            this.fireBeanDefinitionReadyEvent(beanFactory);
        }

        private void fireBeanFactoryConfigurationFrozenEvent(ConfigurableListableBeanFactory beanFactory) {
            BeanFactoryListeners beanFactoryListeners = BeanFactoryListeners.getBean((BeanFactory)beanFactory);
            beanFactoryListeners.onBeanFactoryConfigurationFrozen(beanFactory);
        }

        private void fireBeanDefinitionReadyEvent(ConfigurableListableBeanFactory beanFactory) {
            String[] beanNames = beanFactory.getBeanDefinitionNames();
            BeanListeners beanEventListeners = BeanListeners.getBean((BeanFactory)beanFactory);
            Set<String> readyBeanNames = BeanListeners.getReadyBeanNames(beanFactory);
            beanEventListeners.setReadyBeanNames(readyBeanNames);
            for (String beanName : beanNames) {
                BeanDefinition beanDefinition = beanFactory.getMergedBeanDefinition(beanName);
                if (!(beanDefinition instanceof RootBeanDefinition)) continue;
                RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)beanDefinition;
                beanEventListeners.onBeanDefinitionReady(beanName, rootBeanDefinition);
            }
        }
    }
}

