/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.beans.BeanUtils;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.context.event.ApplicationEventInterceptor;
import io.microsphere.spring.context.event.ApplicationListenerInterceptor;
import io.microsphere.spring.context.event.DefaultApplicationEventInterceptorChain;
import io.microsphere.spring.context.event.DefaultApplicationListenerInterceptorChain;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;

public class InterceptingApplicationEventMulticaster
extends SimpleApplicationEventMulticaster {
    private List<ApplicationEventInterceptor> applicationEventInterceptors;
    private List<ApplicationListenerInterceptor> applicationListenerInterceptors;

    public final void multicastEvent(ApplicationEvent event, @Nullable ResolvableType eventType) {
        this.execute(() -> {
            ResolvableType type = InterceptingApplicationEventMulticaster.resolveEventType(event, eventType);
            DefaultApplicationEventInterceptorChain chain = new DefaultApplicationEventInterceptorChain(this.applicationEventInterceptors, this::doMulticastEvent);
            chain.intercept(event, type);
        });
    }

    static ResolvableType resolveEventType(ApplicationEvent event, ResolvableType eventType) {
        return eventType != null ? eventType : InterceptingApplicationEventMulticaster.resolveDefaultEventType(event);
    }

    static ResolvableType resolveDefaultEventType(ApplicationEvent event) {
        return ResolvableType.forInstance((Object)event);
    }

    protected final void invokeListener(ApplicationListener<?> listener, ApplicationEvent event) {
        DefaultApplicationListenerInterceptorChain chain = new DefaultApplicationListenerInterceptorChain(this.applicationListenerInterceptors, this::doInvokeListener);
        chain.intercept(listener, event);
    }

    protected void doMulticastEvent(ApplicationEvent event, ResolvableType eventType) {
        super.multicastEvent(event, eventType);
    }

    protected void doInvokeListener(ApplicationListener<?> listener, ApplicationEvent event) {
        super.invokeListener(listener, event);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        super.setBeanFactory(beanFactory);
        ListableBeanFactory listableBeanFactory = BeanFactoryUtils.asListableBeanFactory(beanFactory);
        this.applicationEventInterceptors = BeanUtils.getSortedBeans(listableBeanFactory, ApplicationEventInterceptor.class);
        this.applicationListenerInterceptors = BeanUtils.getSortedBeans(listableBeanFactory, ApplicationListenerInterceptor.class);
    }

    protected Executor getTaskExecutor() {
        Executor executor = super.getTaskExecutor();
        if (executor == null) {
            executor = Runnable::run;
        }
        return executor;
    }

    private void execute(Runnable runnable) {
        this.getTaskExecutor().execute(runnable);
    }
}

