/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.beans.BeanUtils;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.config.GenericBeanPostProcessorAdapter;
import io.microsphere.spring.context.event.ApplicationEventInterceptor;
import io.microsphere.spring.context.event.ApplicationListenerInterceptor;
import io.microsphere.spring.context.event.DefaultApplicationEventInterceptorChain;
import io.microsphere.spring.context.event.InterceptingApplicationEventMulticaster;
import io.microsphere.spring.context.event.InterceptingApplicationListener;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.core.ResolvableType;
import org.springframework.core.env.Environment;

public class InterceptingApplicationEventMulticasterProxy
extends GenericBeanPostProcessorAdapter<ApplicationListener>
implements ApplicationEventMulticaster,
BeanFactoryAware {
    public static final String RESET_BEAN_NAME_PROPERTY_NAME = "microsphere.application-event-multicaster.reset-bean-name";
    public static final String DEFAULT_RESET_BEAN_NAME = "applicationEventMulticaster_ORIGINAL";
    private final String delegateBeanName;
    private ApplicationEventMulticaster delegate;
    private List<ApplicationEventInterceptor> applicationEventInterceptors;
    private List<ApplicationListenerInterceptor> applicationListenerInterceptors;
    private Executor taskExecutor;

    public InterceptingApplicationEventMulticasterProxy(Environment environment) {
        this.delegateBeanName = InterceptingApplicationEventMulticasterProxy.getResetBeanName(environment);
    }

    public static String getResetBeanName(Environment environment) {
        return environment.getProperty(RESET_BEAN_NAME_PROPERTY_NAME, DEFAULT_RESET_BEAN_NAME);
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        this.delegate.addApplicationListener(this.wrap(listener));
    }

    public void addApplicationListenerBean(String listenerBeanName) {
        this.delegate.addApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListener(ApplicationListener<?> listener) {
        this.delegate.removeApplicationListener(listener);
    }

    public void removeApplicationListenerBean(String listenerBeanName) {
        this.delegate.removeApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListeners(Predicate<ApplicationListener<?>> predicate) {
        this.delegate.removeApplicationListeners(predicate);
    }

    public void removeApplicationListenerBeans(Predicate<String> predicate) {
        this.delegate.removeApplicationListenerBeans(predicate);
    }

    public void removeAllListeners() {
        this.delegate.removeAllListeners();
    }

    public void multicastEvent(ApplicationEvent event) {
        this.execute(() -> this.delegate.multicastEvent(event));
    }

    public void multicastEvent(ApplicationEvent event, ResolvableType eventType) {
        this.execute(() -> {
            ResolvableType type = InterceptingApplicationEventMulticaster.resolveEventType(event, eventType);
            DefaultApplicationEventInterceptorChain chain = new DefaultApplicationEventInterceptorChain(this.applicationEventInterceptors, this::onEvent);
            chain.intercept(event, type);
        });
    }

    @Override
    protected ApplicationListener doPostProcessAfterInitialization(ApplicationListener bean, String beanName) throws BeansException {
        return this.wrap(bean);
    }

    private ApplicationListener wrap(ApplicationListener listener) {
        return listener instanceof InterceptingApplicationListener ? listener : new InterceptingApplicationListener(listener, this.applicationListenerInterceptors);
    }

    private void onEvent(ApplicationEvent event, ResolvableType resolvableType) {
        this.delegate.multicastEvent(event, resolvableType);
    }

    private void execute(Runnable runnable) {
        this.getTaskExecutor().execute(runnable);
    }

    public void setTaskExecutor(@Nullable Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    protected Executor getTaskExecutor() {
        if (this.taskExecutor == null) {
            this.taskExecutor = Runnable::run;
        }
        return this.taskExecutor;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        ListableBeanFactory listableBeanFactory = BeanFactoryUtils.asListableBeanFactory(beanFactory);
        this.delegate = (ApplicationEventMulticaster)beanFactory.getBean(this.delegateBeanName, ApplicationEventMulticaster.class);
        this.applicationEventInterceptors = BeanUtils.getSortedBeans(listableBeanFactory, ApplicationEventInterceptor.class);
        this.applicationListenerInterceptors = BeanUtils.getSortedBeans(listableBeanFactory, ApplicationListenerInterceptor.class);
    }
}

