/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.spring.context.event.ApplicationListenerInterceptor;
import io.microsphere.spring.context.event.DefaultApplicationListenerInterceptorChain;
import io.microsphere.spring.context.event.GenericApplicationListenerAdapter;
import java.util.List;
import java.util.Objects;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.GenericApplicationListener;
import org.springframework.core.ResolvableType;

class InterceptingApplicationListener
implements GenericApplicationListenerAdapter {
    private final ApplicationListener<?> delegate;
    private final GenericApplicationListener smartListener;
    private final List<ApplicationListenerInterceptor> interceptors;

    InterceptingApplicationListener(ApplicationListener<?> delegate, List<ApplicationListenerInterceptor> interceptors) {
        org.springframework.context.event.GenericApplicationListenerAdapter genericApplicationListenerAdapter;
        this.delegate = delegate;
        if (delegate instanceof GenericApplicationListener) {
            GenericApplicationListener genericApplicationListener = (GenericApplicationListener)delegate;
            genericApplicationListenerAdapter = genericApplicationListener;
        } else {
            genericApplicationListenerAdapter = new org.springframework.context.event.GenericApplicationListenerAdapter(delegate);
        }
        this.smartListener = genericApplicationListenerAdapter;
        this.interceptors = interceptors;
    }

    public boolean supportsEventType(ResolvableType eventType) {
        return this.smartListener.supportsEventType(eventType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        DefaultApplicationListenerInterceptorChain chain = new DefaultApplicationListenerInterceptorChain(this.interceptors, this::onEvent);
        chain.intercept(this.delegate, event);
    }

    private void onEvent(ApplicationListener applicationListener, ApplicationEvent event) {
        applicationListener.onApplicationEvent(event);
    }

    public ApplicationListener<?> getDelegate() {
        ApplicationListener<?> delegate = this.delegate;
        while (delegate instanceof InterceptingApplicationListener) {
            InterceptingApplicationListener interceptingApplicationListener = (InterceptingApplicationListener)delegate;
            delegate = interceptingApplicationListener.delegate;
        }
        return delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InterceptingApplicationListener)) {
            return false;
        }
        InterceptingApplicationListener that = (InterceptingApplicationListener)o;
        return this.getDelegate().equals(that.getDelegate());
    }

    public int hashCode() {
        return Objects.hash(this.getDelegate());
    }
}

