/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.event;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.context.event.BeanListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.springframework.beans.PropertyValues;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class LoggingBeanListener
implements BeanListener {
    private static final Logger logger = LoggerFactory.getLogger(LoggingBeanListener.class);

    @Override
    public boolean supports(String beanName) {
        return true;
    }

    @Override
    public void onBeanDefinitionReady(String beanName, RootBeanDefinition mergedBeanDefinition) {
        logger.info("onBeanDefinitionReady - bean name : {} , definition : {}", new Object[]{beanName, mergedBeanDefinition});
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition) {
        logger.info("onBeforeBeanInstantiate - bean name : {} , definition : {}", new Object[]{beanName, mergedBeanDefinition});
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition, Constructor<?> constructor, Object[] args) {
        logger.info("onBeforeBeanInstantiate - bean name : {} , definition : {} , constructor : {} , args : {}", new Object[]{beanName, mergedBeanDefinition, constructor, Arrays.toString(args)});
    }

    @Override
    public void onBeforeBeanInstantiate(String beanName, RootBeanDefinition mergedBeanDefinition, Object factoryBean, Method factoryMethod, Object[] args) {
        logger.info("onBeforeBeanInstantiate - bean name : {} , definition : {} , factoryBean : {} , factoryMethod : {} , args : {}", new Object[]{beanName, mergedBeanDefinition, factoryBean, factoryMethod, Arrays.toString(args)});
    }

    @Override
    public void onAfterBeanInstantiated(String beanName, RootBeanDefinition mergedBeanDefinition, Object bean) {
        logger.info("onAfterBeanInstantiated - bean name : {} , definition : {} , instance : {}", new Object[]{beanName, mergedBeanDefinition, bean});
    }

    @Override
    public void onBeanPropertyValuesReady(String beanName, Object bean, PropertyValues pvs) {
        logger.info("onBeanPropertyValuesReady - bean name : {} , instance : {} , PropertyValues : {}", new Object[]{beanName, bean, pvs});
    }

    @Override
    public void onBeforeBeanInitialize(String beanName, Object bean) {
        logger.info("onBeforeBeanInitialize - bean name : {} , instance : {}", new Object[]{beanName, bean});
    }

    @Override
    public void onAfterBeanInitialized(String beanName, Object bean) {
        logger.info("onAfterBeanInitialized - bean name : {} , instance : {}", new Object[]{beanName, bean});
    }

    @Override
    public void onBeanReady(String beanName, Object bean) {
        logger.info("onBeanReady - bean name : {} , instance : {}", new Object[]{beanName, bean});
    }

    @Override
    public void onBeforeBeanDestroy(String beanName, Object bean) {
        logger.info("onBeforeBeanDestroy - bean name : {} , instance : {}", new Object[]{beanName, bean});
    }

    @Override
    public void onAfterBeanDestroy(String beanName, Object bean) {
        logger.info("onAfterBeanDestroy - bean name : {} , instance : {}", new Object[]{beanName, bean});
    }
}

