/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.context.lifecycle;

import org.springframework.context.SmartLifecycle;

public abstract class AbstractSmartLifecycle
implements SmartLifecycle {
    public static final int EARLIEST_PHASE = Integer.MIN_VALUE;
    public static final int LATEST_PHASE = Integer.MAX_VALUE;
    public static final int DEFAULT_PHASE = Integer.MAX_VALUE;
    private int phase = Integer.MAX_VALUE;
    private volatile boolean started = false;

    public final void start() {
        this.doStart();
        this.started = true;
    }

    protected abstract void doStart();

    public final void stop() {
        this.doStop();
        this.started = false;
    }

    protected abstract void doStop();

    public final boolean isRunning() {
        return this.started;
    }

    public boolean isAutoStartup() {
        return true;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public final int getPhase() {
        return this.phase;
    }

    public boolean isStarted() {
        return this.started;
    }

    public final void setPhase(int phase) {
        this.phase = phase;
    }

    protected void setStarted(boolean started) {
        this.started = started;
    }
}

