/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core;

import io.microsphere.util.Version;

public enum SpringVersion {
    SPRING_6_0,
    SPRING_6_0_0,
    SPRING_6_0_1,
    SPRING_6_0_2,
    SPRING_6_0_3,
    SPRING_6_0_4,
    SPRING_6_0_5,
    SPRING_6_0_6,
    SPRING_6_0_7,
    SPRING_6_0_8,
    SPRING_6_0_9,
    SPRING_6_0_10,
    SPRING_6_0_11,
    SPRING_6_0_12,
    SPRING_6_0_13,
    SPRING_6_0_14,
    SPRING_6_0_15,
    SPRING_6_0_16,
    SPRING_6_0_17,
    SPRING_6_0_18,
    SPRING_6_0_19,
    SPRING_6_0_20,
    SPRING_6_0_21,
    SPRING_6_0_22,
    SPRING_6_0_23,
    SPRING_6_1,
    SPRING_6_1_0,
    SPRING_6_1_1,
    SPRING_6_1_2,
    SPRING_6_1_3,
    SPRING_6_1_4,
    SPRING_6_1_5,
    SPRING_6_1_6,
    SPRING_6_1_7,
    SPRING_6_1_8,
    SPRING_6_1_9,
    SPRING_6_1_10,
    SPRING_6_1_11,
    SPRING_6_1_12,
    SPRING_6_1_13,
    SPRING_6_1_14,
    SPRING_6_1_15,
    SPRING_6_1_16,
    SPRING_6_2,
    SPRING_6_2_0,
    SPRING_6_2_1,
    CURRENT(Version.of((String)org.springframework.core.SpringVersion.getVersion()));

    private final Version version;

    private SpringVersion() {
        this.version = SpringVersion.resolveVersion(this.name());
    }

    private SpringVersion(Version version) {
        this.version = version;
    }

    static Version resolveVersion(String name) {
        String version = name.substring(7).replace('_', '.');
        return Version.of((String)version);
    }

    public Version getVersion() {
        return this.version;
    }

    public int getMajor() {
        return this.version.getMajor();
    }

    public int getMinor() {
        return this.version.getMinor();
    }

    public int getPatch() {
        return this.version.getPatch();
    }

    public boolean gt(SpringVersion that) {
        return this.version.gt(that.version);
    }

    public boolean isGreaterThan(SpringVersion that) {
        return this.version.isGreaterThan(that.version);
    }

    public boolean ge(SpringVersion that) {
        return this.version.ge(that.version);
    }

    public boolean isGreaterOrEqual(SpringVersion that) {
        return this.version.isGreaterOrEqual(that.version);
    }

    public boolean lt(SpringVersion that) {
        return this.version.lt(that.version);
    }

    public boolean isLessThan(SpringVersion that) {
        return this.version.isLessThan(that.version);
    }

    public boolean le(SpringVersion that) {
        return this.version.le(that.version);
    }

    public boolean isLessOrEqual(SpringVersion that) {
        return this.version.isLessOrEqual(that.version);
    }

    public boolean eq(SpringVersion that) {
        return this.version.eq(that.version);
    }

    public boolean equals(SpringVersion that) {
        return this.version.equals(that.version);
    }
}

