/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AnnotationUtils {
    public static <A extends Annotation> boolean isPresent(Method method, Class<A> annotationClass) {
        Map<ElementType, List<A>> annotationsMap = AnnotationUtils.findAnnotations(method, annotationClass);
        return !annotationsMap.isEmpty();
    }

    public static <A extends Annotation> Map<ElementType, List<A>> findAnnotations(Method method, Class<A> annotationClass) {
        ElementType[] elementTypes;
        Retention retention = annotationClass.getAnnotation(Retention.class);
        RetentionPolicy retentionPolicy = retention.value();
        if (!RetentionPolicy.RUNTIME.equals((Object)retentionPolicy)) {
            return Collections.emptyMap();
        }
        LinkedHashMap annotationsMap = new LinkedHashMap();
        Target target = annotationClass.getAnnotation(Target.class);
        for (ElementType elementType : elementTypes = target.value()) {
            LinkedList<Annotation> annotationsList = new LinkedList<Annotation>();
            switch (elementType) {
                case PARAMETER: {
                    Annotation[][] parameterAnnotations;
                    Annotation[][] annotationArray = parameterAnnotations = method.getParameterAnnotations();
                    int n = annotationArray.length;
                    for (int i = 0; i < n; ++i) {
                        Annotation[] annotations;
                        for (Annotation annotation : annotations = annotationArray[i]) {
                            if (!annotationClass.equals(annotation.annotationType())) continue;
                            annotationsList.add(annotation);
                        }
                    }
                    break;
                }
                case METHOD: {
                    Annotation annotation = org.springframework.core.annotation.AnnotationUtils.findAnnotation((Method)method, annotationClass);
                    if (annotation == null) break;
                    annotationsList.add(annotation);
                    break;
                }
                case TYPE: {
                    Class<?> beanType = method.getDeclaringClass();
                    Annotation annotation2 = org.springframework.core.annotation.AnnotationUtils.findAnnotation(beanType, annotationClass);
                    if (annotation2 == null) break;
                    annotationsList.add(annotation2);
                }
            }
            if (annotationsList.isEmpty()) continue;
            annotationsMap.put(elementType, annotationsList);
        }
        return Collections.unmodifiableMap(annotationsMap);
    }

    public static Map<String, Object> getAttributes(Annotation annotation, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAttributes(annotation, null, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static Map<String, Object> getAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAttributes(annotation, propertyResolver, false, false, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static Map<String, Object> getAttributes(Map<String, Object> annotationAttributes, PropertyResolver propertyResolver, String ... ignoreAttributeNames) {
        HashSet<String> ignoreAttributeNamesSet = new HashSet<String>(Arrays.asList(ignoreAttributeNames));
        LinkedHashMap<String, Object> actualAttributes = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> annotationAttribute : annotationAttributes.entrySet()) {
            String attributeName = annotationAttribute.getKey();
            String[] attributeValue = annotationAttribute.getValue();
            if (ignoreAttributeNamesSet.contains(attributeName)) continue;
            if (attributeValue instanceof String) {
                String value = (String)attributeValue;
                attributeValue = AnnotationUtils.resolvePlaceholders(value, propertyResolver);
            } else if (attributeValue instanceof String[]) {
                String[] values = attributeValue;
                for (int i = 0; i < values.length; ++i) {
                    values[i] = AnnotationUtils.resolvePlaceholders(values[i], propertyResolver);
                }
                attributeValue = values;
            }
            actualAttributes.put(attributeName, attributeValue);
        }
        return actualAttributes;
    }

    public static Map<String, Object> getAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        AnnotationAttributes annotationAttributes = org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)annotation, (boolean)classValuesAsString, (boolean)nestedAnnotationsAsMap);
        String[] actualIgnoreAttributeNames = ignoreAttributeNames;
        if (ignoreDefaultValue && !CollectionUtils.isEmpty((Map)annotationAttributes)) {
            LinkedList<String> attributeNamesToIgnore = new LinkedList<String>(Arrays.asList(ignoreAttributeNames));
            for (Map.Entry annotationAttribute : annotationAttributes.entrySet()) {
                String attributeName = (String)annotationAttribute.getKey();
                Object attributeValue = annotationAttribute.getValue();
                if (!ObjectUtils.nullSafeEquals(attributeValue, (Object)org.springframework.core.annotation.AnnotationUtils.getDefaultValue((Annotation)annotation, (String)attributeName))) continue;
                attributeNamesToIgnore.add(attributeName);
            }
            actualIgnoreAttributeNames = attributeNamesToIgnore.toArray(new String[0]);
        }
        return AnnotationUtils.getAttributes((Map<String, Object>)annotationAttributes, propertyResolver, actualIgnoreAttributeNames);
    }

    private static String resolvePlaceholders(String attributeValue, PropertyResolver propertyResolver) {
        String resolvedValue = attributeValue;
        if (propertyResolver != null) {
            resolvedValue = StringUtils.hasText((String)(resolvedValue = propertyResolver.resolvePlaceholders(resolvedValue))) ? resolvedValue.strip() : resolvedValue;
        }
        return resolvedValue;
    }

    public static <T> T getAttribute(Annotation annotation, String attributeName) {
        return AnnotationUtils.getAttribute(org.springframework.core.annotation.AnnotationUtils.getAnnotationAttributes((Annotation)annotation), attributeName);
    }

    public static <T> T getAttribute(Map<String, Object> attributes, String attributeName) {
        return AnnotationUtils.getAttribute(attributes, attributeName, false);
    }

    public static <T> T getAttribute(Map<String, Object> attributes, String attributeName, boolean required) {
        T value = AnnotationUtils.getAttribute(attributes, attributeName, null);
        if (required && value == null) {
            throw new IllegalStateException("The attribute['" + attributeName + "] is required!");
        }
        return value;
    }

    public static <T> T getAttribute(Map<String, Object> attributes, String attributeName, T defaultValue) {
        Object value = attributes.get(attributeName);
        return (T)(value == null ? defaultValue : value);
    }

    public static <T> T getRequiredAttribute(Map<String, Object> attributes, String attributeName) {
        return AnnotationUtils.getAttribute(attributes, attributeName, true);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAnnotationAttributes(annotation, null, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationAttributes.fromMap(AnnotationUtils.getAttributes(annotation, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames));
    }

    public static AnnotationAttributes getAnnotationAttributes(Annotation annotation, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAnnotationAttributes(annotation, propertyResolver, false, false, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotationType, propertyResolver, false, false, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        Annotation annotation = annotatedElement.getAnnotation(annotationType);
        return annotation == null ? null : AnnotationUtils.getAnnotationAttributes(annotation, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean ignoreDefaultValue, boolean tryMergedAnnotation, String ... ignoreAttributeNames) {
        return AnnotationUtils.getAnnotationAttributes(annotatedElement, annotationType, propertyResolver, false, false, ignoreDefaultValue, tryMergedAnnotation, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, boolean tryMergedAnnotation, String ... ignoreAttributeNames) {
        AnnotationAttributes attributes = null;
        if (tryMergedAnnotation) {
            attributes = AnnotationUtils.tryGetMergedAnnotationAttributes(annotatedElement, annotationType, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
        }
        if (attributes == null) {
            attributes = AnnotationUtils.getAnnotationAttributes(annotatedElement, annotationType, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
        }
        return attributes;
    }

    @Nullable
    public static Annotation tryGetMergedAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.tryGetMergedAnnotation(annotatedElement, annotationType, false, false);
    }

    @Nullable
    public static Annotation tryGetMergedAnnotation(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, boolean classValuesAsString, boolean nestedAnnotationsAsMap) {
        AnnotationAttributes annotationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)annotatedElement, (String)annotationType.getName(), (boolean)classValuesAsString, (boolean)nestedAnnotationsAsMap);
        return annotationAttributes == null ? null : org.springframework.core.annotation.AnnotationUtils.synthesizeAnnotation((Map)annotationAttributes, annotationType, (AnnotatedElement)annotatedElement);
    }

    public static AnnotationAttributes tryGetMergedAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        return AnnotationUtils.tryGetMergedAnnotationAttributes(annotatedElement, annotationType, propertyResolver, false, false, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes tryGetMergedAnnotationAttributes(AnnotatedElement annotatedElement, Class<? extends Annotation> annotationType, PropertyResolver propertyResolver, boolean classValuesAsString, boolean nestedAnnotationsAsMap, boolean ignoreDefaultValue, String ... ignoreAttributeNames) {
        Annotation annotation = AnnotationUtils.tryGetMergedAnnotation(annotatedElement, annotationType, classValuesAsString, nestedAnnotationsAsMap);
        return annotation == null ? null : AnnotationUtils.getAnnotationAttributes(annotation, propertyResolver, classValuesAsString, nestedAnnotationsAsMap, ignoreDefaultValue, ignoreAttributeNames);
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotationMetadata metadata, Class<? extends Annotation> annotationType) {
        return AnnotationUtils.getAnnotationAttributes(metadata, annotationType.getName());
    }

    public static AnnotationAttributes getAnnotationAttributes(AnnotationMetadata metadata, String annotationClassName) {
        return AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(annotationClassName));
    }

    @Nullable
    public static <A extends Annotation> Class<A> findAnnotationType(AnnotationAttributes annotationAttributes) {
        if (annotationAttributes == null) {
            return null;
        }
        return annotationAttributes.annotationType();
    }
}

