/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.annotation;

import io.microsphere.spring.core.annotation.AnnotationUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.annotation.AnnotationAttributes;

public class GenericAnnotationAttributes<A extends Annotation>
extends AnnotationAttributes {
    @Nullable
    private final Class<A> annotationType;

    public GenericAnnotationAttributes(A annotation) {
        this((Map<String, Object>)AnnotationUtils.getAnnotationAttributes(annotation, false, new String[0]), annotation.annotationType());
    }

    public GenericAnnotationAttributes(AnnotationAttributes another) {
        this((Map<String, Object>)another, AnnotationUtils.findAnnotationType(another));
    }

    public GenericAnnotationAttributes(Map<String, Object> another, Class<A> annotationType) {
        super(another);
        this.annotationType = annotationType;
    }

    @Nullable
    public Class<A> annotationType() {
        return this.annotationType;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AnnotationAttributes)) {
            return false;
        }
        AnnotationAttributes that = (AnnotationAttributes)o;
        if (this.size() == that.size()) {
            for (Map.Entry entry : this.entrySet()) {
                Object thatAttributeValue;
                String attributeName = (String)entry.getKey();
                Object attributeValue = entry.getValue();
                if (Objects.deepEquals(attributeValue, thatAttributeValue = that.get((Object)attributeName))) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int h = 0;
        for (Map.Entry entry : this.entrySet()) {
            String attributeName = (String)entry.getKey();
            h += 31 * attributeName.hashCode();
            Object attributeValue = entry.getValue();
            if (attributeValue == null) continue;
            Class<?> attributeValueType = attributeValue.getClass();
            if (attributeValueType.isArray()) {
                h += 31 * Arrays.deepHashCode((Object[])attributeValue);
                continue;
            }
            h += 31 * attributeValue.hashCode();
        }
        return h;
    }

    @Nonnull
    public static <A extends Annotation> GenericAnnotationAttributes<A> of(@Nonnull A annotation) {
        return new GenericAnnotationAttributes<A>(annotation);
    }

    @Nonnull
    public static <A extends Annotation> GenericAnnotationAttributes<A> of(@Nonnull AnnotationAttributes attributes) {
        if (attributes instanceof GenericAnnotationAttributes) {
            GenericAnnotationAttributes genericAnnotationAttributes = (GenericAnnotationAttributes)attributes;
            return genericAnnotationAttributes;
        }
        return new GenericAnnotationAttributes<A>(attributes);
    }

    @Nonnull
    public static Set<AnnotationAttributes> ofSet(AnnotationAttributes ... attributesArray) {
        int length;
        int n = length = attributesArray == null ? 0 : attributesArray.length;
        if (length < 1) {
            return Collections.emptySet();
        }
        LinkedHashSet<AnnotationAttributes> annotationAttributesSet = new LinkedHashSet<AnnotationAttributes>();
        for (int i = 0; i < length; ++i) {
            AnnotationAttributes annotationAttributes = attributesArray[i];
            annotationAttributesSet.add(GenericAnnotationAttributes.of(annotationAttributes));
        }
        return annotationAttributesSet;
    }
}

