/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.convert;

import io.microsphere.convert.Converter;
import io.microsphere.util.ServiceLoaderUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;

public class SpringConverterAdapter
implements ConditionalGenericConverter {
    public static final SpringConverterAdapter INSTANCE = new SpringConverterAdapter();
    private static final Map<GenericConverter.ConvertiblePair, Converter> convertersMap = SpringConverterAdapter.loadConvertersMap();

    private static Map<GenericConverter.ConvertiblePair, Converter> loadConvertersMap() {
        List converters = ServiceLoaderUtils.loadServicesList(Converter.class);
        int size = converters.size();
        HashMap<GenericConverter.ConvertiblePair, Converter> convertersMap = new HashMap<GenericConverter.ConvertiblePair, Converter>(size);
        for (int i = 0; i < size; ++i) {
            Converter converter = (Converter)converters.get(i);
            GenericConverter.ConvertiblePair convertiblePair = SpringConverterAdapter.buildConvertiblePair(converter);
            convertersMap.put(convertiblePair, converter);
        }
        return convertersMap;
    }

    static GenericConverter.ConvertiblePair buildConvertiblePair(Converter converter) {
        return SpringConverterAdapter.buildConvertiblePair(converter.getSourceType(), converter.getTargetType());
    }

    static GenericConverter.ConvertiblePair buildConvertiblePair(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return new GenericConverter.ConvertiblePair(sourceType.getType(), targetType.getType());
    }

    static GenericConverter.ConvertiblePair buildConvertiblePair(Class<?> sourceType, Class<?> targetType) {
        return new GenericConverter.ConvertiblePair(sourceType, targetType);
    }

    static Converter getConverter(TypeDescriptor sourceType, TypeDescriptor targetType) {
        GenericConverter.ConvertiblePair convertiblePair = SpringConverterAdapter.buildConvertiblePair(sourceType, targetType);
        return convertersMap.get(convertiblePair);
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        GenericConverter.ConvertiblePair convertiblePair = SpringConverterAdapter.buildConvertiblePair(sourceType, targetType);
        return convertersMap.containsKey(convertiblePair);
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return convertersMap.keySet();
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Converter converter = SpringConverterAdapter.getConverter(sourceType, targetType);
        return converter.convert(source);
    }
}

