/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.env;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.BaseUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class EnvironmentUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(EnvironmentUtils.class);

    public static ConfigurableEnvironment asConfigurableEnvironment(Environment environment) throws IllegalArgumentException {
        Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment, (String)"The 'environment' argument is not a instance of ConfigurableEnvironment, is it running in Spring container?");
        return (ConfigurableEnvironment)environment;
    }

    @Nonnull
    public static Map<String, String> getProperties(Environment environment, String ... propertyNames) {
        int length;
        int n = length = propertyNames == null ? 0 : propertyNames.length;
        if (length < 1) {
            return Collections.emptyMap();
        }
        if (length == 1) {
            String propertyName = propertyNames[0];
            return StringUtils.hasText((String)propertyName) ? Collections.singletonMap(propertyName, environment.getProperty(propertyName)) : Collections.emptyMap();
        }
        return EnvironmentUtils.getProperties(environment, Arrays.asList(propertyNames));
    }

    @Nonnull
    public static Map<String, String> getProperties(Environment environment, Iterable<String> propertyNames) {
        Set set;
        if (propertyNames instanceof Set) {
            Set names;
            set = names = (Set)propertyNames;
        } else if (propertyNames instanceof Collection) {
            Collection names = (Collection)propertyNames;
            set = new HashSet(names);
        } else {
            set = StreamSupport.stream(propertyNames.spliterator(), false).collect(Collectors.toSet());
        }
        Set propertyNamesSet = set;
        return EnvironmentUtils.getProperties(environment, propertyNamesSet);
    }

    @Nonnull
    public static Map<String, String> getProperties(Environment environment, Set<String> propertyNames) {
        HashMap properties = new HashMap(propertyNames.size());
        propertyNames.stream().filter(StringUtils::hasText).forEach(name -> properties.put(name, environment.getProperty(name)));
        return Collections.unmodifiableMap(properties);
    }

    @Nullable
    public static ConversionService getConversionService(Environment environment) {
        ConfigurablePropertyResolver resolver;
        ConfigurableConversionService conversionService = null;
        if (environment instanceof ConfigurablePropertyResolver && (conversionService = (resolver = (ConfigurablePropertyResolver)environment).getConversionService()) == null) {
            conversionService = DefaultConversionService.getSharedInstance();
            logger.warn("ConversionService can't be resolved from Environment[class: {}], the shared ApplicationConversionService will be used!", new Object[]{environment.getClass().getName()});
        }
        return conversionService;
    }

    @Nonnull
    public static List<String> resolveCommaDelimitedValueToList(Environment environment, String commaDelimitedValue) {
        List values = EnvironmentUtils.resolvePlaceholders(environment, commaDelimitedValue, List.class);
        return values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
    }

    @Nullable
    public static <T> T resolvePlaceholders(Environment environment, String propertyValue, Class<T> targetType) {
        return EnvironmentUtils.resolvePlaceholders(environment, propertyValue, targetType, null);
    }

    @Nullable
    public static <T> T resolvePlaceholders(Environment environment, String propertyValue, Class<T> targetType, T defaultValue) {
        Object targetValue;
        if (propertyValue == null) {
            return defaultValue;
        }
        ConversionService conversionService = EnvironmentUtils.getConversionService(environment);
        if (conversionService == null) {
            return defaultValue;
        }
        String resolvedPropertyValue = environment.resolvePlaceholders(propertyValue);
        if (conversionService.canConvert(String.class, targetType)) {
            targetValue = conversionService.convert((Object)resolvedPropertyValue, targetType);
            logger.trace("The property value[origin : {} , resolved : {}] was converted to be {}(type :{})!", new Object[]{propertyValue, resolvedPropertyValue, targetValue, targetType});
        } else {
            targetValue = defaultValue;
            logger.trace("The property value[origin : {} , resolved : {}] can't be converted to be the target type[{}], take the default value({}) as result!", new Object[]{propertyValue, resolvedPropertyValue, targetValue, targetType});
        }
        return targetValue;
    }
}

