/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.env;

import io.microsphere.invoke.MethodHandleUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.core.env.EnvironmentListener;
import io.microsphere.spring.core.env.ProfileListener;
import io.microsphere.spring.core.env.PropertyResolverListener;
import io.microsphere.spring.core.io.support.SpringFactoriesLoaderUtils;
import java.lang.invoke.MethodHandle;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MissingRequiredPropertiesException;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.Profiles;

public class ListenableConfigurableEnvironment
implements ConfigurableEnvironment {
    private static final Logger logger = LoggerFactory.getLogger(ListenableConfigurableEnvironment.class);
    public static final String PROPERTY_NAME_PREFIX = "microsphere.spring.listenable-environment.";
    public static final String ENABLED_PROPERTY_NAME = "microsphere.spring.listenable-environment.enabled";
    @Nullable
    private static final MethodHandle SET_ESCAPE_CHARACTER_METHOD_HANDLE = MethodHandleUtils.findVirtual(ConfigurablePropertyResolver.class, (String)"setEscapeCharacter", (Class[])new Class[]{Character.class});
    public static final boolean ENABLED_PROPERTY_VALUE = false;
    private final ConfigurableEnvironment delegate;
    private List<EnvironmentListener> environmentListeners;
    private final List<ProfileListener> profileListeners;
    private final List<PropertyResolverListener> propertyResolverListeners;

    public ListenableConfigurableEnvironment(ConfigurableApplicationContext applicationContext) {
        this.delegate = applicationContext.getEnvironment();
        List<EnvironmentListener> environmentListeners = ListenableConfigurableEnvironment.loadEnvironmentListeners(applicationContext);
        this.environmentListeners = environmentListeners;
        this.profileListeners = this.loadProfileListeners(applicationContext, environmentListeners);
        this.propertyResolverListeners = this.loadPropertyResolverListeners(applicationContext, environmentListeners);
    }

    private static List<EnvironmentListener> loadEnvironmentListeners(ConfigurableApplicationContext applicationContext) {
        return SpringFactoriesLoaderUtils.loadFactories(applicationContext, EnvironmentListener.class);
    }

    private List<ProfileListener> loadProfileListeners(ConfigurableApplicationContext applicationContext, List<EnvironmentListener> environmentListeners) {
        LinkedList<ProfileListener> profileListeners = new LinkedList<ProfileListener>(environmentListeners);
        profileListeners.addAll(SpringFactoriesLoaderUtils.loadFactories(applicationContext, ProfileListener.class));
        AnnotationAwareOrderComparator.sort(profileListeners);
        return profileListeners;
    }

    private List<PropertyResolverListener> loadPropertyResolverListeners(ConfigurableApplicationContext applicationContext, List<EnvironmentListener> environmentListeners) {
        LinkedList<PropertyResolverListener> propertyResolverListeners = new LinkedList<PropertyResolverListener>(environmentListeners);
        propertyResolverListeners.addAll(SpringFactoriesLoaderUtils.loadFactories(applicationContext, PropertyResolverListener.class));
        AnnotationAwareOrderComparator.sort(propertyResolverListeners);
        return propertyResolverListeners;
    }

    public void setActiveProfiles(String ... profiles) {
        this.forEachProfileListener(listener -> listener.beforeSetActiveProfiles(this.delegate, profiles));
        this.delegate.setActiveProfiles(profiles);
        this.forEachProfileListener(listener -> listener.afterSetActiveProfiles(this.delegate, profiles));
    }

    public void addActiveProfile(String profile) {
        this.forEachProfileListener(listener -> listener.beforeAddActiveProfile(this.delegate, profile));
        this.delegate.addActiveProfile(profile);
        this.forEachProfileListener(listener -> listener.afterAddActiveProfile(this.delegate, profile));
    }

    public void setDefaultProfiles(String ... profiles) {
        this.forEachProfileListener(listener -> listener.beforeSetDefaultProfiles(this.delegate, profiles));
        this.delegate.setDefaultProfiles(profiles);
        this.forEachProfileListener(listener -> listener.afterSetDefaultProfiles(this.delegate, profiles));
    }

    public MutablePropertySources getPropertySources() {
        this.forEachEnvironmentListener(listener -> listener.beforeGetPropertySources(this.delegate));
        MutablePropertySources propertySources = this.delegate.getPropertySources();
        this.forEachEnvironmentListener(listener -> listener.afterGetPropertySources(this.delegate, propertySources));
        return propertySources;
    }

    public Map<String, Object> getSystemProperties() {
        this.forEachEnvironmentListener(listener -> listener.beforeGetSystemProperties(this.delegate));
        Map systemProperties = this.delegate.getSystemProperties();
        this.forEachEnvironmentListener(listener -> listener.afterGetSystemProperties(this.delegate, systemProperties));
        return systemProperties;
    }

    public Map<String, Object> getSystemEnvironment() {
        this.forEachEnvironmentListener(listener -> listener.beforeGetSystemEnvironment(this.delegate));
        Map systemEnvironment = this.delegate.getSystemEnvironment();
        this.forEachEnvironmentListener(listener -> listener.afterGetSystemEnvironment(this.delegate, systemEnvironment));
        return systemEnvironment;
    }

    public void merge(ConfigurableEnvironment parent) {
        this.forEachEnvironmentListener(listener -> listener.beforeMerge(this.delegate, parent));
        this.delegate.merge(parent);
        this.forEachEnvironmentListener(listener -> listener.afterMerge(this.delegate, parent));
    }

    public String[] getActiveProfiles() {
        this.forEachProfileListener(listener -> listener.beforeGetActiveProfiles((Environment)this.delegate));
        String[] activeProfiles = this.delegate.getActiveProfiles();
        this.forEachProfileListener(listener -> listener.afterGetActiveProfiles((Environment)this.delegate, activeProfiles));
        return activeProfiles;
    }

    public String[] getDefaultProfiles() {
        this.forEachProfileListener(listener -> listener.beforeGetDefaultProfiles((Environment)this.delegate));
        String[] defaultProfiles = this.delegate.getDefaultProfiles();
        this.forEachProfileListener(listener -> listener.afterGetDefaultProfiles((Environment)this.delegate, defaultProfiles));
        return defaultProfiles;
    }

    public boolean matchesProfiles(String ... profileExpressions) {
        return this.delegate.matchesProfiles(profileExpressions);
    }

    @Deprecated
    public boolean acceptsProfiles(String ... profiles) {
        return this.delegate.acceptsProfiles(profiles);
    }

    public boolean acceptsProfiles(Profiles profiles) {
        return this.delegate.acceptsProfiles(profiles);
    }

    public boolean containsProperty(String key) {
        return this.delegate.containsProperty(key);
    }

    @Nullable
    public String getProperty(String key) {
        this.forEachPropertyResolverListener(listener -> listener.beforeGetProperty((ConfigurablePropertyResolver)this.delegate, key, String.class, null));
        String value = this.delegate.getProperty(key);
        this.forEachPropertyResolverListener(listener -> listener.afterGetProperty((ConfigurablePropertyResolver)this.delegate, key, String.class, value, null));
        return value;
    }

    public String getProperty(String key, String defaultValue) {
        this.forEachPropertyResolverListener(listener -> listener.beforeGetProperty((ConfigurablePropertyResolver)this.delegate, key, String.class, defaultValue));
        String value = this.delegate.getProperty(key, defaultValue);
        this.forEachPropertyResolverListener(listener -> listener.afterGetProperty((ConfigurablePropertyResolver)this.delegate, key, String.class, value, defaultValue));
        return value;
    }

    @Nullable
    public <T> T getProperty(String key, Class<T> targetType) {
        this.forEachPropertyResolverListener(listener -> listener.beforeGetProperty((ConfigurablePropertyResolver)this.delegate, key, targetType, null));
        Object value = this.delegate.getProperty(key, targetType);
        this.forEachPropertyResolverListener(listener -> listener.afterGetProperty((ConfigurablePropertyResolver)this.delegate, key, targetType, value, null));
        return (T)value;
    }

    public <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        this.forEachPropertyResolverListener(listener -> listener.beforeGetProperty((ConfigurablePropertyResolver)this.delegate, key, targetType, defaultValue));
        Object value = this.delegate.getProperty(key, targetType, defaultValue);
        this.forEachPropertyResolverListener(listener -> listener.afterGetProperty((ConfigurablePropertyResolver)this.delegate, key, targetType, value, defaultValue));
        return (T)value;
    }

    public String getRequiredProperty(String key) throws IllegalStateException {
        this.forEachPropertyResolverListener(listener -> listener.beforeGetRequiredProperty((ConfigurablePropertyResolver)this.delegate, key, String.class));
        String value = this.delegate.getRequiredProperty(key);
        this.forEachPropertyResolverListener(listener -> listener.afterGetRequiredProperty((ConfigurablePropertyResolver)this.delegate, key, String.class, value));
        return value;
    }

    public <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        this.forEachPropertyResolverListener(listener -> listener.beforeGetRequiredProperty((ConfigurablePropertyResolver)this.delegate, key, targetType));
        Object value = this.delegate.getRequiredProperty(key, targetType);
        this.forEachPropertyResolverListener(listener -> listener.afterGetRequiredProperty((ConfigurablePropertyResolver)this.delegate, key, targetType, value));
        return (T)value;
    }

    public String resolvePlaceholders(String text) {
        this.forEachPropertyResolverListener(listener -> listener.beforeResolvePlaceholders((ConfigurablePropertyResolver)this.delegate, text));
        String result = this.delegate.resolvePlaceholders(text);
        this.forEachPropertyResolverListener(listener -> listener.afterResolvePlaceholders((ConfigurablePropertyResolver)this.delegate, text, result));
        return result;
    }

    public String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        this.forEachPropertyResolverListener(listener -> listener.beforeResolveRequiredPlaceholders((ConfigurablePropertyResolver)this.delegate, text));
        String result = this.delegate.resolveRequiredPlaceholders(text);
        this.forEachPropertyResolverListener(listener -> listener.afterResolveRequiredPlaceholders((ConfigurablePropertyResolver)this.delegate, text, result));
        return result;
    }

    public ConfigurableConversionService getConversionService() {
        this.forEachPropertyResolverListener(listener -> listener.beforeGetConversionService((ConfigurablePropertyResolver)this.delegate));
        ConfigurableConversionService conversionService = this.delegate.getConversionService();
        this.forEachPropertyResolverListener(listener -> listener.afterGetConversionService((ConfigurablePropertyResolver)this.delegate, conversionService));
        return conversionService;
    }

    public void setConversionService(ConfigurableConversionService conversionService) {
        this.forEachPropertyResolverListener(listener -> listener.beforeSetConversionService((ConfigurablePropertyResolver)this.delegate, conversionService));
        this.delegate.setConversionService(conversionService);
        this.forEachPropertyResolverListener(listener -> listener.afterSetConversionService((ConfigurablePropertyResolver)this.delegate, conversionService));
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.forEachEnvironmentListener(listener -> listener.beforeSetPlaceholderPrefix((ConfigurablePropertyResolver)this.delegate, placeholderPrefix));
        this.delegate.setPlaceholderPrefix(placeholderPrefix);
        this.forEachEnvironmentListener(listener -> listener.afterSetPlaceholderPrefix((ConfigurablePropertyResolver)this.delegate, placeholderPrefix));
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.forEachEnvironmentListener(listener -> listener.beforeSetPlaceholderSuffix((ConfigurablePropertyResolver)this.delegate, placeholderSuffix));
        this.delegate.setPlaceholderSuffix(placeholderSuffix);
        this.forEachEnvironmentListener(listener -> listener.afterSetPlaceholderSuffix((ConfigurablePropertyResolver)this.delegate, placeholderSuffix));
    }

    public void setValueSeparator(String valueSeparator) {
        this.forEachEnvironmentListener(listener -> listener.beforeSetValueSeparator((ConfigurablePropertyResolver)this.delegate, valueSeparator));
        this.delegate.setValueSeparator(valueSeparator);
        this.forEachEnvironmentListener(listener -> listener.afterSetValueSeparator((ConfigurablePropertyResolver)this.delegate, valueSeparator));
    }

    public void setEscapeCharacter(Character escapeCharacter) {
        block3: {
            if (SET_ESCAPE_CHARACTER_METHOD_HANDLE != null) {
                try {
                    SET_ESCAPE_CHARACTER_METHOD_HANDLE.invokeExact(this.delegate, escapeCharacter);
                }
                catch (Throwable e) {
                    if (!logger.isWarnEnabled()) break block3;
                    logger.warn("Failed to invokeExact on {} with arg : '{}'", new Object[]{SET_ESCAPE_CHARACTER_METHOD_HANDLE, escapeCharacter, e});
                }
            }
        }
        throw new UnsupportedOperationException("The method setEscapeCharacter(Character) is not supported before Spring Framework 6.2");
    }

    public void setIgnoreUnresolvableNestedPlaceholders(boolean ignoreUnresolvableNestedPlaceholders) {
        this.forEachEnvironmentListener(listener -> listener.beforeSetIgnoreUnresolvableNestedPlaceholders((ConfigurablePropertyResolver)this.delegate, ignoreUnresolvableNestedPlaceholders));
        this.delegate.setIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders);
        this.forEachEnvironmentListener(listener -> listener.afterSetIgnoreUnresolvableNestedPlaceholders((ConfigurablePropertyResolver)this.delegate, ignoreUnresolvableNestedPlaceholders));
    }

    public void setRequiredProperties(String ... requiredProperties) {
        this.forEachEnvironmentListener(listener -> listener.beforeSetRequiredProperties((ConfigurablePropertyResolver)this.delegate, requiredProperties));
        this.delegate.setRequiredProperties(requiredProperties);
        this.forEachEnvironmentListener(listener -> listener.afterSetRequiredProperties((ConfigurablePropertyResolver)this.delegate, requiredProperties));
    }

    public void validateRequiredProperties() throws MissingRequiredPropertiesException {
        this.forEachEnvironmentListener(listener -> listener.beforeValidateRequiredProperties((ConfigurablePropertyResolver)this.delegate));
        this.delegate.validateRequiredProperties();
        this.forEachEnvironmentListener(listener -> listener.afterValidateRequiredProperties((ConfigurablePropertyResolver)this.delegate));
    }

    @Nonnull
    public ConfigurableEnvironment getDelegate() {
        return this.delegate;
    }

    public <T> Class<T> getPropertyAsClass(String key, Class<T> targetType) {
        throw new UnsupportedOperationException();
    }

    public static void setEnvironmentIfEnabled(ConfigurableApplicationContext applicationContext) {
        ConfigurableEnvironment environment = applicationContext.getEnvironment();
        if (!ListenableConfigurableEnvironment.isEnabled((Environment)environment) && environment instanceof ListenableConfigurableEnvironment) {
            return;
        }
        applicationContext.setEnvironment((ConfigurableEnvironment)new ListenableConfigurableEnvironment(applicationContext));
    }

    public static boolean isEnabled(Environment environment) {
        return (Boolean)environment.getProperty(ENABLED_PROPERTY_NAME, Boolean.TYPE, (Object)false);
    }

    private void forEachEnvironmentListener(Consumer<EnvironmentListener> listenerConsumer) {
        this.forEachListener(this.environmentListeners, listenerConsumer);
    }

    private void forEachProfileListener(Consumer<ProfileListener> listenerConsumer) {
        this.forEachListener(this.profileListeners, listenerConsumer);
    }

    private void forEachPropertyResolverListener(Consumer<PropertyResolverListener> listenerConsumer) {
        this.forEachListener(this.propertyResolverListeners, listenerConsumer);
    }

    private <T> void forEachListener(List<T> listeners, Consumer<T> consumer) {
        int size = listeners.size();
        if (size < 1) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            T listener = listeners.get(i);
            try {
                consumer.accept(listener);
                continue;
            }
            catch (Throwable e) {
                if (!logger.isErrorEnabled()) continue;
                logger.error("Listener(type : '{}' , index : {}) execution is failed!", new Object[]{listener.getClass().getTypeName(), i, e});
            }
        }
    }
}

