/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.env;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.core.env.EnvironmentListener;
import java.util.Arrays;
import java.util.Map;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.ConfigurablePropertyResolver;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MutablePropertySources;

public class LoggingEnvironmentListener
implements EnvironmentListener {
    private static final Logger logger = LoggerFactory.getLogger(LoggingEnvironmentListener.class);

    @Override
    public void beforeGetPropertySources(ConfigurableEnvironment environment) {
        this.log("beforeGetPropertySources()");
    }

    @Override
    public void afterGetPropertySources(ConfigurableEnvironment environment, MutablePropertySources propertySources) {
        this.log("afterGetPropertySources() : {}", propertySources);
    }

    @Override
    public void beforeGetSystemProperties(ConfigurableEnvironment environment) {
        this.log("beforeGetSystemProperties()");
    }

    @Override
    public void afterGetSystemProperties(ConfigurableEnvironment environment, Map<String, Object> systemProperties) {
        this.log("afterGetSystemProperties() : {}", systemProperties);
    }

    @Override
    public void beforeGetSystemEnvironment(ConfigurableEnvironment environment) {
        this.log("beforeGetSystemEnvironment()");
    }

    @Override
    public void afterGetSystemEnvironment(ConfigurableEnvironment environment, Map<String, Object> systemEnvironmentVariables) {
        this.log("afterGetSystemEnvironment() : {}", systemEnvironmentVariables);
    }

    @Override
    public void beforeMerge(ConfigurableEnvironment environment, ConfigurableEnvironment parentEnvironment) {
        this.log("beforeMerge(parentEnvironment : {})", parentEnvironment);
    }

    @Override
    public void afterMerge(ConfigurableEnvironment environment, ConfigurableEnvironment parentEnvironment) {
        this.log("afterMerge(parentEnvironment : {})", parentEnvironment);
    }

    @Override
    public void beforeGetActiveProfiles(Environment environment) {
        this.log("beforeGetActiveProfiles()");
    }

    @Override
    public void afterGetActiveProfiles(Environment environment, String[] activeProfiles) {
        this.log("afterGetActiveProfiles() : {}", Arrays.toString(activeProfiles));
    }

    @Override
    public void beforeGetDefaultProfiles(Environment environment) {
        this.log("beforeGetDefaultProfiles");
    }

    @Override
    public void afterGetDefaultProfiles(Environment environment, String[] defaultProfiles) {
        this.log("afterGetDefaultProfiles() : {}", Arrays.toString(defaultProfiles));
    }

    @Override
    public void beforeSetActiveProfiles(ConfigurableEnvironment environment, String[] profiles) {
        this.log("beforeSetActiveProfiles() : {}", Arrays.toString(profiles));
    }

    @Override
    public void afterSetActiveProfiles(ConfigurableEnvironment environment, String[] profiles) {
        this.log("afterSetActiveProfiles(profiles : {})", Arrays.toString(profiles));
    }

    @Override
    public void beforeAddActiveProfile(ConfigurableEnvironment environment, String profile) {
        this.log("beforeAddActiveProfile(profile : '{}')", profile);
    }

    @Override
    public void afterAddActiveProfile(ConfigurableEnvironment environment, String profile) {
        this.log("afterAddActiveProfile(profile : '{}')", profile);
    }

    @Override
    public void beforeSetDefaultProfiles(ConfigurableEnvironment environment, String[] profiles) {
        this.log("beforeSetDefaultProfiles(profiles : {})", Arrays.toString(profiles));
    }

    @Override
    public void afterSetDefaultProfiles(ConfigurableEnvironment environment, String[] profiles) {
        this.log("afterSetDefaultProfiles(profiles : {})", Arrays.toString(profiles));
    }

    @Override
    public void beforeGetProperty(ConfigurablePropertyResolver propertyResolver, String name, Class<?> targetType, Object defaultValue) {
        this.log("beforeGetProperty(name : '{}', targetType : {} , defaultValue : {})", name, targetType, defaultValue);
    }

    @Override
    public void afterGetProperty(ConfigurablePropertyResolver propertyResolver, String name, Class<?> targetType, Object value, Object defaultValue) {
        this.log("afterGetProperty(name : '{}', targetType : {} , defaultValue : {}) : {}", name, targetType, defaultValue, value);
    }

    @Override
    public void beforeGetRequiredProperty(ConfigurablePropertyResolver propertyResolver, String name, Class<?> targetType) {
        this.log("beforeGetRequiredProperty(name : '{}', targetType : {})", name, targetType);
    }

    @Override
    public void afterGetRequiredProperty(ConfigurablePropertyResolver propertyResolver, String name, Class<?> targetType, Object value) {
        this.log("afterGetRequiredProperty(name : '{}', targetType : {}) : {}", name, targetType, value);
    }

    @Override
    public void beforeResolvePlaceholders(ConfigurablePropertyResolver propertyResolver, String text) {
        this.log("beforeResolvePlaceholders(text : '{}')", text);
    }

    @Override
    public void afterResolvePlaceholders(ConfigurablePropertyResolver propertyResolver, String text, String result) {
        this.log("afterResolvePlaceholders(text : '{}') : '{}'", text, result);
    }

    @Override
    public void beforeResolveRequiredPlaceholders(ConfigurablePropertyResolver propertyResolver, String text) {
        this.log("beforeResolveRequiredPlaceholders(text : '{}')", text);
    }

    @Override
    public void afterResolveRequiredPlaceholders(ConfigurablePropertyResolver propertyResolver, String text, String result) {
        this.log("afterResolveRequiredPlaceholders(text : '{}') : '{}'", text, result);
    }

    @Override
    public void beforeSetRequiredProperties(ConfigurablePropertyResolver propertyResolver, String[] properties) {
        this.log("beforeSetRequiredProperties(properties : {})", Arrays.toString(properties));
    }

    @Override
    public void afterSetRequiredProperties(ConfigurablePropertyResolver propertyResolver, String[] properties) {
        this.log("afterSetRequiredProperties(properties : {})", Arrays.toString(properties));
    }

    @Override
    public void beforeValidateRequiredProperties(ConfigurablePropertyResolver propertyResolver) {
        this.log("beforeValidateRequiredProperties()");
    }

    @Override
    public void afterValidateRequiredProperties(ConfigurablePropertyResolver propertyResolver) {
        this.log("afterValidateRequiredProperties()");
    }

    @Override
    public void beforeGetConversionService(ConfigurablePropertyResolver propertyResolver) {
        this.log("beforeGetConversionService()");
    }

    @Override
    public void afterGetConversionService(ConfigurablePropertyResolver propertyResolver, ConfigurableConversionService conversionService) {
        this.log("afterGetConversionService() : {}", conversionService);
    }

    @Override
    public void beforeSetConversionService(ConfigurablePropertyResolver propertyResolver, ConfigurableConversionService conversionService) {
        this.log("beforeSetConversionService(conversionService : {})", conversionService);
    }

    @Override
    public void afterSetConversionService(ConfigurablePropertyResolver propertyResolver, ConfigurableConversionService conversionService) {
        this.log("afterSetConversionService(conversionService : {})", conversionService);
    }

    @Override
    public void beforeSetPlaceholderPrefix(ConfigurablePropertyResolver propertyResolver, String prefix) {
        this.log("beforeSetPlaceholderPrefix(prefix : '{}')", prefix);
    }

    @Override
    public void afterSetPlaceholderPrefix(ConfigurablePropertyResolver propertyResolver, String prefix) {
        this.log("afterSetPlaceholderPrefix(prefix : '{}')", prefix);
    }

    @Override
    public void beforeSetPlaceholderSuffix(ConfigurablePropertyResolver propertyResolver, String suffix) {
        this.log("beforeSetPlaceholderSuffix(suffix : '{}')", suffix);
    }

    @Override
    public void afterSetPlaceholderSuffix(ConfigurablePropertyResolver propertyResolver, String suffix) {
        this.log("afterSetPlaceholderSuffix(suffix : '{}')", suffix);
    }

    @Override
    public void beforeSetIgnoreUnresolvableNestedPlaceholders(ConfigurablePropertyResolver propertyResolver, boolean ignoreUnresolvableNestedPlaceholders) {
        this.log("beforeSetIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders : {})", ignoreUnresolvableNestedPlaceholders);
    }

    @Override
    public void afterSetIgnoreUnresolvableNestedPlaceholders(ConfigurablePropertyResolver propertyResolver, boolean ignoreUnresolvableNestedPlaceholders) {
        this.log("afterSetIgnoreUnresolvableNestedPlaceholders(ignoreUnresolvableNestedPlaceholders : {})", ignoreUnresolvableNestedPlaceholders);
    }

    @Override
    public void beforeSetValueSeparator(ConfigurablePropertyResolver propertyResolver, String valueSeparator) {
        this.log("beforeSetValueSeparator(valueSeparator : '{}'}", valueSeparator);
    }

    @Override
    public void afterSetValueSeparator(ConfigurablePropertyResolver propertyResolver, String valueSeparator) {
        this.log("afterSetValueSeparator(valueSeparator : '{}'}", valueSeparator);
    }

    protected void log(String message) {
        if (logger.isTraceEnabled()) {
            logger.trace(message);
        }
    }

    protected void log(String messagePattern, Object ... args) {
        if (logger.isTraceEnabled()) {
            logger.trace(messagePattern, args);
        }
    }
}

