/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.env;

import io.microsphere.collection.MapUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.BaseUtils;
import io.microsphere.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.PropertySources;
import org.springframework.core.env.PropertySourcesPropertyResolver;

public abstract class PropertySourcesUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(PropertySourcesUtils.class);
    public static final String DEFAULT_PROPERTIES_PROPERTY_SOURCE_NAME = "defaultProperties";
    private static final String ATTACHED_PROPERTY_SOURCE_NAME = "configurationProperties";
    public static final String BOOTSTRAP_PROPERTY_SOURCE_NAME = "bootstrap";

    public static <T extends PropertySource<?>> T getPropertySource(ConfigurableEnvironment environment, String propertySourceName, Class<T> propertySourceType) {
        return PropertySourcesUtils.getPropertySource(environment, propertySourceName, propertySourceType, null);
    }

    public static <T extends PropertySource<?>> T getPropertySource(ConfigurableEnvironment environment, String propertySourceName, Class<T> propertySourceType, Supplier<T> propertySourceSupplierIfAbsent) {
        MutablePropertySources propertySources = environment.getPropertySources();
        PropertySource propertySource = propertySources.get(propertySourceName);
        PropertySource targetPropertySource = null;
        if (propertySource == null) {
            logger.trace("The '{}' PropertySource can't be found!", new Object[]{propertySourceName});
            if (propertySourceSupplierIfAbsent != null && (targetPropertySource = (PropertySource)propertySourceSupplierIfAbsent.get()) != null) {
                logger.trace("A new PropertySource[{}] will be created.", new Object[]{targetPropertySource});
                propertySources.addLast(targetPropertySource);
            }
        } else if (propertySourceType.isInstance(propertySource)) {
            logger.trace("The '{}' PropertySource[type: {}] was found!", new Object[]{propertySourceName, propertySource.getClass().getName()});
            targetPropertySource = (PropertySource)propertySourceType.cast(propertySource);
        } else {
            logger.warn("The '{}' PropertySource is not a {} instance, actual type : {}", new Object[]{propertySource.getClass().getName(), propertySourceType.getName()});
        }
        return (T)targetPropertySource;
    }

    public static MapPropertySource getMapPropertySource(ConfigurableEnvironment environment, String propertySourceName) {
        return PropertySourcesUtils.getMapPropertySource(environment, propertySourceName, false);
    }

    public static MapPropertySource getMapPropertySource(ConfigurableEnvironment environment, String propertySourceName, boolean created) {
        Supplier<MapPropertySource> propertySourceSupplierIfAbsent = created ? () -> new MapPropertySource(propertySourceName, new HashMap()) : null;
        return PropertySourcesUtils.getPropertySource(environment, propertySourceName, MapPropertySource.class, propertySourceSupplierIfAbsent);
    }

    public static PropertySource findConfiguredPropertySource(ConfigurableEnvironment environment, String propertyName) {
        return PropertySourcesUtils.findConfiguredPropertySource(environment.getPropertySources(), propertyName);
    }

    public static PropertySource findConfiguredPropertySource(Iterable<PropertySource<?>> propertySources, String propertyName) {
        PropertySource<?> configuredPropertySource = null;
        for (PropertySource<?> propertySource : propertySources) {
            if (propertySource.getName().equals(ATTACHED_PROPERTY_SOURCE_NAME) || !propertySource.containsProperty(propertyName)) continue;
            configuredPropertySource = propertySource;
            break;
        }
        return configuredPropertySource;
    }

    public static String findConfiguredPropertySourceName(ConfigurableEnvironment environment, String propertyName) {
        return PropertySourcesUtils.findConfiguredPropertySourceName(environment.getPropertySources(), propertyName);
    }

    public static String findConfiguredPropertySourceName(Iterable<PropertySource<?>> propertySources, String propertyName) {
        PropertySource configuredPropertySource = PropertySourcesUtils.findConfiguredPropertySource(propertySources, propertyName);
        return configuredPropertySource == null ? null : configuredPropertySource.getName();
    }

    public static Set<String> findPropertyNamesByPrefix(ConfigurableEnvironment environment, String propertyNamePrefix) {
        return PropertySourcesUtils.findPropertyNames(environment, propertyName -> propertyName.startsWith(propertyNamePrefix));
    }

    public static Set<String> findPropertyNames(ConfigurableEnvironment environment, Predicate<String> propertyNameFilter) {
        LinkedHashSet<String> propertyNames = new LinkedHashSet<String>();
        for (PropertySource propertySource : environment.getPropertySources()) {
            if (!(propertySource instanceof EnumerablePropertySource)) continue;
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            for (String propertyName : enumerablePropertySource.getPropertyNames()) {
                if (!propertyNameFilter.test(propertyName)) continue;
                propertyNames.add(propertyName);
            }
        }
        return Collections.unmodifiableSet(propertyNames);
    }

    public static Map<String, Object> getSubProperties(Iterable<PropertySource<?>> propertySources, String prefix) {
        MutablePropertySources mutablePropertySources = new MutablePropertySources();
        for (PropertySource<?> source : propertySources) {
            mutablePropertySources.addLast(source);
        }
        return PropertySourcesUtils.getSubProperties((PropertySources)mutablePropertySources, prefix);
    }

    public static Map<String, Object> getSubProperties(ConfigurableEnvironment environment, String prefix) {
        return PropertySourcesUtils.getSubProperties((PropertySources)environment.getPropertySources(), (PropertyResolver)environment, prefix);
    }

    public static String normalizePrefix(String prefix) {
        return prefix.endsWith(".") ? prefix : prefix + ".";
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, String prefix) {
        return PropertySourcesUtils.getSubProperties(propertySources, (PropertyResolver)new PropertySourcesPropertyResolver(propertySources), prefix);
    }

    public static Map<String, Object> getSubProperties(PropertySources propertySources, PropertyResolver propertyResolver, String prefix) {
        LinkedHashMap<String, Object> subProperties = new LinkedHashMap<String, Object>();
        String normalizedPrefix = PropertySourcesUtils.normalizePrefix(prefix);
        for (PropertySource source : propertySources) {
            for (String name : PropertySourcesUtils.getPropertyNames(source)) {
                String subName;
                if (subProperties.containsKey(name) || !name.startsWith(normalizedPrefix) || subProperties.containsKey(subName = name.substring(normalizedPrefix.length()))) continue;
                Object value = source.getProperty(name);
                if (value instanceof String) {
                    String propertyValue = (String)value;
                    value = propertyResolver.resolvePlaceholders(propertyValue);
                }
                subProperties.put(subName, value);
            }
        }
        return Collections.unmodifiableMap(subProperties);
    }

    @Nonnull
    public static String[] getPropertyNames(PropertySource propertySource) {
        String[] propertyNames;
        if (propertySource instanceof EnumerablePropertySource) {
            EnumerablePropertySource enumerablePropertySource = (EnumerablePropertySource)propertySource;
            v0 = enumerablePropertySource.getPropertyNames();
        } else {
            v0 = propertyNames = null;
        }
        if (propertyNames == null) {
            propertyNames = StringUtils.EMPTY_STRING_ARRAY;
        }
        return propertyNames;
    }

    @Nonnull
    public static Map<String, Object> getProperties(PropertySource propertySource) {
        String[] propertyNames = PropertySourcesUtils.getPropertyNames(propertySource);
        int length = propertyNames.length;
        if (length < 1) {
            return Collections.emptyMap();
        }
        LinkedHashMap properties = MapUtils.newLinkedHashMap((int)length, (float)Float.MIN_NORMAL);
        for (int i = 0; i < length; ++i) {
            String propertyName = propertyNames[i];
            properties.put(propertyName, propertySource.getProperty(propertyName));
        }
        return Collections.unmodifiableMap(properties);
    }

    public static void addDefaultProperties(ConfigurableEnvironment environment, String key, Object value, Object ... others) {
        Map<String, Object> defaultProperties = PropertySourcesUtils.getDefaultProperties(environment);
        defaultProperties.put(key, value);
        int length = others.length;
        int i = 0;
        while (i < length) {
            String k = String.valueOf(others[i++]);
            Object v = others[i++];
            defaultProperties.put(k, v);
        }
    }

    public static Map<String, Object> getDefaultProperties(ConfigurableEnvironment environment) {
        return PropertySourcesUtils.getDefaultProperties(environment, true);
    }

    public static Map<String, Object> getDefaultProperties(ConfigurableEnvironment environment, boolean createIfAbsent) {
        Map defaultProperties = null;
        MapPropertySource defaultPropertiesPropertySource = PropertySourcesUtils.getDefaultPropertiesPropertySource(environment, createIfAbsent);
        if (defaultPropertiesPropertySource != null) {
            defaultProperties = (Map)defaultPropertiesPropertySource.getSource();
            logger.trace("The 'defaultProperties' property was obtained successfully, and the current content is: {}", new Object[]{defaultProperties});
        }
        return defaultProperties;
    }

    public static MapPropertySource getDefaultPropertiesPropertySource(ConfigurableEnvironment environment) {
        return PropertySourcesUtils.getDefaultPropertiesPropertySource(environment, true);
    }

    public static MapPropertySource getDefaultPropertiesPropertySource(ConfigurableEnvironment environment, boolean createIfAbsent) {
        MutablePropertySources propertySources = environment.getPropertySources();
        String name = DEFAULT_PROPERTIES_PROPERTY_SOURCE_NAME;
        PropertySource propertySource = propertySources.get(DEFAULT_PROPERTIES_PROPERTY_SOURCE_NAME);
        MapPropertySource defaultPropertiesPropertySource = null;
        if (propertySource == null && createIfAbsent) {
            logger.warn("The 'defaultProperties' property will create an MapPropertySource[name:{}] by default", new Object[]{DEFAULT_PROPERTIES_PROPERTY_SOURCE_NAME});
            defaultPropertiesPropertySource = new MapPropertySource(DEFAULT_PROPERTIES_PROPERTY_SOURCE_NAME, new HashMap());
            propertySources.addLast((PropertySource)defaultPropertiesPropertySource);
        } else if (propertySource instanceof MapPropertySource) {
            MapPropertySource mapPropertySource = (MapPropertySource)propertySource;
            logger.trace("The 'defaultProperties' property was initialized");
            defaultPropertiesPropertySource = mapPropertySource;
        } else {
            logger.warn("'defaultProperties' PropertySource[name: {}] is not an MapPropertySource instance; it is actually: {}", new Object[]{DEFAULT_PROPERTIES_PROPERTY_SOURCE_NAME, propertySource.getClass().getName()});
        }
        return defaultPropertiesPropertySource;
    }

    public static boolean containsPropertySource(ConfigurableEnvironment environment, String propertySourceName) {
        MutablePropertySources propertySources = environment.getPropertySources();
        return propertySources.contains(propertySourceName);
    }

    public static boolean containsBootstrapPropertySource(ConfigurableEnvironment environment) {
        return PropertySourcesUtils.containsPropertySource(environment, BOOTSTRAP_PROPERTY_SOURCE_NAME);
    }
}

