/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.io;

import io.microsphere.util.BaseUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ShutdownHookUtils;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

public abstract class ResourceLoaderUtils
extends BaseUtils {
    private static ConcurrentMap<ClassLoader, ResourceLoader> resourceLoadersCache = new ConcurrentHashMap<ClassLoader, ResourceLoader>();

    @Nonnull
    public static ResourceLoader getResourceLoader() {
        return ResourceLoaderUtils.getResourceLoader(ClassLoaderUtils.getDefaultClassLoader());
    }

    @Nonnull
    public static ResourceLoader getResourceLoader(@Nullable ClassLoader classLoader) {
        ClassLoader targetClassLoader = classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
        return resourceLoadersCache.computeIfAbsent(targetClassLoader, PathMatchingResourcePatternResolver::new);
    }

    @Nonnull
    public static ResourcePatternResolver getResourcePatternResolver() {
        return ResourceLoaderUtils.getResourcePatternResolver(null);
    }

    @Nonnull
    public static ResourcePatternResolver getResourcePatternResolver(@Nullable ResourceLoader resourceLoader) {
        ClassLoader classLoader = ResourceLoaderUtils.getClassLoader(resourceLoader);
        return (ResourcePatternResolver)resourceLoadersCache.computeIfAbsent(classLoader, cl -> {
            ResourcePatternResolver resolver;
            Object resourcePatternResolver = null;
            resourcePatternResolver = resourceLoader instanceof ResourcePatternResolver ? (resolver = (ResourcePatternResolver)resourceLoader) : new PathMatchingResourcePatternResolver(cl);
            return resourcePatternResolver;
        });
    }

    protected static ClassLoader getClassLoader(@Nullable ResourceLoader resourceLoader) {
        ClassLoader classLoader = resourceLoader == null ? null : resourceLoader.getClassLoader();
        return classLoader == null ? ClassLoaderUtils.getDefaultClassLoader() : classLoader;
    }

    static {
        ShutdownHookUtils.addShutdownHookCallback(resourceLoadersCache::clear);
    }
}

