/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.core.io.support;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.BeanUtils;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.context.ApplicationContextUtils;
import io.microsphere.util.BaseUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public abstract class SpringFactoriesLoaderUtils
extends BaseUtils {
    private static final Logger logger = LoggerFactory.getLogger(SpringFactoriesLoaderUtils.class);

    public static <T> List<T> loadFactories(@Nullable ApplicationContext context, Class<T> factoryType) {
        return SpringFactoriesLoaderUtils.loadFactories(ApplicationContextUtils.asConfigurableApplicationContext(context), factoryType);
    }

    public static <T> List<T> loadFactories(@Nullable ConfigurableApplicationContext context, Class<T> factoryType) {
        ClassLoader classLoader = context == null ? ClassLoaderUtils.getDefaultClassLoader() : context.getClassLoader();
        List factories = SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)classLoader);
        for (int i = 0; i < factories.size(); ++i) {
            Object factory = factories.get(i);
            BeanUtils.invokeBeanInterfaces(factory, context);
        }
        return factories;
    }

    public static <T> List<T> loadFactories(@Nullable ConfigurableApplicationContext context, Class<T> factoryClass, Object ... args) {
        int argsLength;
        int n = argsLength = args == null ? 0 : args.length;
        if (argsLength < 1) {
            return SpringFactoriesLoaderUtils.loadFactories(context, factoryClass);
        }
        ClassLoader classLoader = context == null ? ClassLoaderUtils.getDefaultClassLoader() : context.getClassLoader();
        List factoryClassNames = SpringFactoriesLoader.loadFactoryNames(factoryClass, (ClassLoader)classLoader);
        int factorySize = factoryClassNames.size();
        if (factorySize < 1) {
            logger.trace("No factory class {} were loaded from SpringFactoriesLoader[{}]", new Object[]{factoryClass.getName(), "META-INF/spring.factories"});
            return Collections.emptyList();
        }
        ArrayList<Object> factories = new ArrayList<Object>(factorySize);
        for (String factoryClassName : factoryClassNames) {
            Class factoryImplClass = ClassUtils.resolveClassName((String)factoryClassName, (ClassLoader)classLoader);
            Constructor constructor = SpringFactoriesLoaderUtils.findConstructor(factoryImplClass, args, argsLength);
            Object factory = org.springframework.beans.BeanUtils.instantiateClass((Constructor)constructor, (Object[])args);
            BeanUtils.invokeBeanInterfaces(factory, context);
            factories.add(factory);
        }
        return Collections.unmodifiableList(factories);
    }

    public static <T> List<T> loadFactories(@Nullable BeanFactory beanFactory, Class<T> factoryType) {
        ApplicationContext context = ApplicationContextUtils.asApplicationContext(beanFactory);
        if (context != null) {
            return SpringFactoriesLoaderUtils.loadFactories(context, factoryType);
        }
        ConfigurableBeanFactory configurableBeanFactory = BeanFactoryUtils.asConfigurableBeanFactory(beanFactory);
        ClassLoader classLoader = configurableBeanFactory == null ? ClassLoaderUtils.getDefaultClassLoader() : configurableBeanFactory.getBeanClassLoader();
        List factories = SpringFactoriesLoader.loadFactories(factoryType, (ClassLoader)classLoader);
        for (int i = 0; i < factories.size(); ++i) {
            Object factory = factories.get(i);
            BeanUtils.invokeAwareInterfaces(factory, beanFactory, configurableBeanFactory);
        }
        return factories;
    }

    private static Constructor findConstructor(Class<?> factoryImplClass, Object[] args, int argsLength) {
        Constructor<?> targetConstructor = null;
        Constructor<?>[] constructors = factoryImplClass.getConstructors();
        boolean matched = true;
        for (Constructor<?> constructor : constructors) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            int parameterCount = parameterTypes.length;
            if (parameterCount != argsLength) continue;
            for (int i = 0; i < argsLength; ++i) {
                Class<?> parameterType = parameterTypes[i];
                Object arg = args[i];
                if (parameterType.isInstance(arg)) continue;
                matched = false;
            }
            if (!matched) continue;
            targetConstructor = constructor;
        }
        if (targetConstructor == null) {
            throw new IllegalArgumentException(String.format("No Constructor of Factory class[name : %s] was found for arguments : %s", factoryImplClass.getName(), StringUtils.arrayToCommaDelimitedString((Object[])args)));
        }
        return targetConstructor;
    }
}

