/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.net;

import io.microsphere.spring.net.SpringPropertySourcesURLConnectionAdapter;
import io.microsphere.spring.net.SpringSubProtocolURLConnectionFactory;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySources;

public class SpringEnvironmentURLConnectionFactory
extends SpringSubProtocolURLConnectionFactory {
    public static final String PROPERTY_SOURCES_TYPE = "property-sources";
    public static final String PROFILES_TYPE = "profiles";
    private static final int TYPE_INDEX = 1;
    private final ConfigurableEnvironment environment;
    private final ConfigurableConversionService conversionService;

    public SpringEnvironmentURLConnectionFactory(ConfigurableEnvironment environment, ConfigurableConversionService conversionService) {
        this.environment = environment;
        this.conversionService = conversionService;
    }

    @Override
    protected String getSubProtocol() {
        return "env";
    }

    public URLConnection create(URL url, List<String> subProtocols, Proxy proxy) throws IOException {
        String type = this.getType(subProtocols);
        SpringPropertySourcesURLConnectionAdapter urlConnection = null;
        switch (type) {
            case "profiles": {
                break;
            }
            default: {
                urlConnection = new SpringPropertySourcesURLConnectionAdapter(url, (PropertySources)this.environment.getPropertySources(), this.conversionService);
            }
        }
        return urlConnection;
    }

    private String getType(List<String> subProtocols) {
        return subProtocols.get(1);
    }
}

