/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.net;

import io.microsphere.net.ExtendableProtocolURLStreamHandler;
import io.microsphere.net.SubProtocolURLConnectionFactory;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.core.convert.SpringConverterAdapter;
import io.microsphere.spring.core.convert.support.ConversionServiceResolver;
import io.microsphere.spring.core.env.EnvironmentUtils;
import io.microsphere.spring.net.SpringDelegatingBeanProtocolURLConnectionFactory;
import io.microsphere.spring.net.SpringEnvironmentURLConnectionFactory;
import io.microsphere.spring.net.SpringResourceURLConnectionFactory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;

public class SpringProtocolURLStreamHandler
extends ExtendableProtocolURLStreamHandler
implements InitializingBean,
ResourceLoaderAware,
BeanFactoryAware,
EnvironmentAware {
    public static final String PROTOCOL = "spring";
    private ResourceLoader resourceLoader;
    private ConfigurableListableBeanFactory beanFactory;
    private ConfigurableEnvironment environment;
    private ConfigurableConversionService conversionService;

    public SpringProtocolURLStreamHandler() {
        super(PROTOCOL);
    }

    public void afterPropertiesSet() throws Exception {
        this.initConversionService();
        super.init();
    }

    private void initConversionService() {
        ConfigurableConversionService conversionService = (ConfigurableConversionService)new ConversionServiceResolver((ConfigurableBeanFactory)this.beanFactory).resolve();
        conversionService.addConverter((GenericConverter)new SpringConverterAdapter());
        this.conversionService = conversionService;
    }

    protected void initSubProtocolURLConnectionFactories(List<SubProtocolURLConnectionFactory> factories) {
        factories.add(new SpringResourceURLConnectionFactory(this.getResourceLoader()));
        factories.add(new SpringEnvironmentURLConnectionFactory(this.environment, this.conversionService));
        factories.add(new SpringDelegatingBeanProtocolURLConnectionFactory((ListableBeanFactory)this.beanFactory));
    }

    protected URLConnection openConnection(URL url, Proxy proxy) throws IOException {
        List subProtocols = this.resolveSubProtocols(url);
        int size = subProtocols.size();
        if (size < 1) {
            throw new MalformedURLException("The Spring Protocol URLStreamHandler must contain the sub-protocol part , like 'spring:{sub-protocol}:...'");
        }
        return super.openConnection(url, proxy);
    }

    public ResourceLoader getResourceLoader() {
        ResourceLoader resourceLoader = this.resourceLoader;
        if (resourceLoader == null) {
            resourceLoader = new DefaultResourceLoader();
        }
        return resourceLoader;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = BeanFactoryUtils.asConfigurableListableBeanFactory(beanFactory);
    }

    public void setEnvironment(Environment environment) {
        this.environment = EnvironmentUtils.asConfigurableEnvironment(environment);
    }
}

