/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.net;

import io.microsphere.net.DelegatingURLConnection;
import io.microsphere.spring.net.SpringResourceURLConnectionAdapter;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.springframework.core.io.Resource;

public class SpringResourceURLConnection
extends DelegatingURLConnection {
    private final Resource resource;

    public SpringResourceURLConnection(URL rawURL, Resource resource) throws IOException {
        super(SpringResourceURLConnection.getDelegate(rawURL, resource));
        this.resource = resource;
    }

    private static URLConnection getDelegate(URL rawURL, Resource resource) {
        URLConnection delegate = null;
        URL url = null;
        try {
            url = resource.getURL();
            delegate = url.openConnection();
        }
        catch (IOException e) {
            delegate = new SpringResourceURLConnectionAdapter(rawURL, resource);
        }
        return delegate;
    }

    public Resource getResource() {
        return this.resource;
    }
}

