/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.jdbc.p6spy.annotation;

import com.p6spy.engine.spy.P6ModuleManager;
import com.p6spy.engine.spy.option.P6OptionChangedListener;
import io.microsphere.spring.beans.BeanUtils;
import io.microsphere.spring.beans.factory.BeanFactoryUtils;
import io.microsphere.spring.beans.factory.support.BeanRegistrar;
import io.microsphere.spring.jdbc.p6spy.beans.factory.CompoundJdbcEventListenerFactory;
import io.microsphere.spring.jdbc.p6spy.beans.factory.config.P6DataSourceBeanPostProcessor;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

class P6DataSourceBeanDefinitionRegistrar
implements ImportBeanDefinitionRegistrar,
BeanFactoryAware {
    P6DataSourceBeanDefinitionRegistrar() {
    }

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        BeanRegistrar.registerBeanDefinition((BeanDefinitionRegistry)registry, P6DataSourceBeanPostProcessor.class);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.initP6ModuleManager(BeanFactoryUtils.asConfigurableListableBeanFactory((Object)beanFactory));
    }

    private void initP6ModuleManager(ConfigurableListableBeanFactory beanFactory) {
        P6ModuleManager p6ModuleManager = P6ModuleManager.getInstance();
        this.addP6Factory(p6ModuleManager, beanFactory);
        this.registerP6OptionChangedListenerBeans(p6ModuleManager, beanFactory);
    }

    private void addP6Factory(P6ModuleManager p6ModuleManager, ConfigurableListableBeanFactory beanFactory) {
        CompoundJdbcEventListenerFactory p6Factory = new CompoundJdbcEventListenerFactory(beanFactory);
        List factories = p6ModuleManager.getFactories();
        factories.add(p6Factory);
    }

    private void registerP6OptionChangedListenerBeans(P6ModuleManager p6ModuleManager, ConfigurableListableBeanFactory beanFactory) {
        List listeners = BeanUtils.getSortedBeans((ListableBeanFactory)beanFactory, P6OptionChangedListener.class);
        listeners.forEach(arg_0 -> ((P6ModuleManager)p6ModuleManager).registerOptionChangedListener(arg_0));
    }
}

