/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.jdbc.p6spy.beans.factory.config;

import com.p6spy.engine.spy.P6DataSource;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.spring.beans.factory.config.GenericBeanPostProcessorAdapter;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class P6DataSourceBeanPostProcessor
extends GenericBeanPostProcessorAdapter<DataSource>
implements EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(P6DataSourceBeanPostProcessor.class);
    public static final String EXCLUDED_DATASOURCE_BEAN_NAMES_PROPERTY_NAME = "microsphere.jdbc.p6spy.excluded-datasource-beans";
    private Set<String> excludedDataSourceBeanNames;

    protected DataSource doPostProcessAfterInitialization(DataSource bean, String beanName) throws BeansException {
        DataSource targetDataSource = bean;
        if (this.excludedDataSourceBeanNames.contains(beanName)) {
            logger.trace("The DataSource bean[name : '{}'] is excluded, it caused by Spring property[name : '{}']", new Object[]{beanName, EXCLUDED_DATASOURCE_BEAN_NAMES_PROPERTY_NAME});
        } else {
            try {
                DataSource datasource = bean.unwrap(DataSource.class);
                targetDataSource = new P6DataSource(datasource);
            }
            catch (SQLException e) {
                logger.trace("The DataSource bean[name : '{}' , class : '{}'] can't unwrap to be an instance DataSource", new Object[]{beanName, bean.getClass().getName()});
            }
        }
        logger.trace("The DataSource bean[name : '{}'] {} -> {}", new Object[]{beanName, bean, targetDataSource});
        return targetDataSource;
    }

    public void setEnvironment(Environment environment) {
        this.excludedDataSourceBeanNames = (Set)environment.getProperty(EXCLUDED_DATASOURCE_BEAN_NAMES_PROPERTY_NAME, Set.class, Collections.emptySet());
    }
}

