/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.event;

import io.microsphere.spring.context.lifecycle.AbstractSmartLifecycle;
import io.microsphere.spring.web.event.HandlerMethodArgumentsResolvedEvent;
import io.microsphere.spring.web.event.WebEndpointMappingsReadyEvent;
import io.microsphere.spring.web.metadata.WebEndpointMapping;
import io.microsphere.spring.web.metadata.WebEndpointMappingRegistry;
import io.microsphere.spring.web.method.support.HandlerMethodInterceptor;
import java.util.Collection;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.method.HandlerMethod;

public class WebEventPublisher
extends AbstractSmartLifecycle
implements HandlerMethodInterceptor {
    public static final int DEFAULT_PHASE = -2147483548;
    private final ApplicationContext context;

    public WebEventPublisher(ApplicationContext context) {
        this.context = context;
        this.setPhase(-2147483548);
    }

    @Override
    public void beforeExecute(HandlerMethod handlerMethod, Object[] args, NativeWebRequest request) throws Exception {
        this.context.publishEvent((ApplicationEvent)new HandlerMethodArgumentsResolvedEvent((WebRequest)request, handlerMethod, args));
    }

    @Override
    public void afterExecute(HandlerMethod handlerMethod, Object[] args, Object returnValue, Throwable error, NativeWebRequest request) throws Exception {
    }

    protected void doStart() {
        WebEndpointMappingRegistry webEndpointMappingRegistry = (WebEndpointMappingRegistry)this.context.getBean(WebEndpointMappingRegistry.class);
        Collection<WebEndpointMapping> webEndpointMappings = webEndpointMappingRegistry.getWebEndpointMappings();
        this.context.publishEvent((ApplicationEvent)new WebEndpointMappingsReadyEvent(this.context, webEndpointMappings));
    }

    protected void doStop() {
    }
}

