/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.metadata;

import io.microsphere.constants.SeparatorConstants;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class WebEndpointMapping<E> {
    public static final String ID_HEADER_NAME = "microsphere_wem_id";
    public static final Object NON_ENDPOINT = new Object();
    public static final Object NON_SOURCE = new Object();
    private final transient Kind kind;
    private final transient E endpoint;
    private final int id;
    private final String[] patterns;
    private final String[] methods;
    private final String[] params;
    private final String[] headers;
    private final String[] consumes;
    private final String[] produces;
    private final transient Object source;
    private transient int hashCode = 0;
    private transient Map<String, Object> attributes;

    public static Builder<?> of(Collection<String> patterns) {
        return WebEndpointMapping.of(null, null, patterns);
    }

    public static Builder<?> of(String ... patterns) {
        return WebEndpointMapping.of(null, null, patterns);
    }

    public static <E> Builder<E> of(@Nullable E endpoint, Collection<String> patterns) {
        return WebEndpointMapping.of(null, endpoint, patterns);
    }

    public static <E> Builder<E> of(@Nullable E endpoint, String ... patterns) {
        return WebEndpointMapping.of(null, endpoint, patterns);
    }

    public static <E> Builder<E> of(@Nullable Kind kind, @Nullable E endpoint, Collection<String> patterns) {
        return WebEndpointMapping.of(kind, endpoint, (String[])ArrayUtils.asArray(patterns, String.class));
    }

    public static <E> Builder of(@Nullable Kind kind, @Nullable E endpoint, String ... patterns) {
        return new Builder(kind, endpoint, patterns);
    }

    private WebEndpointMapping(Kind kind, E endpoint, Object source, String[] patterns, @Nullable String[] methods, @Nullable String[] params, @Nullable String[] headers, @Nullable String[] consumes, @Nullable String[] produces) {
        this.kind = kind;
        this.endpoint = endpoint;
        this.id = endpoint == null ? 0 : endpoint.hashCode();
        this.source = source == null ? NON_SOURCE : source;
        this.patterns = patterns;
        this.methods = methods;
        this.params = params;
        this.headers = headers;
        this.consumes = consumes;
        this.produces = produces;
    }

    private WebEndpointMapping() {
        this(null, null, null, null, null, null, null, null, null);
    }

    @NonNull
    public Kind getKind() {
        return this.kind;
    }

    @NonNull
    public E getEndpoint() {
        return this.endpoint;
    }

    public int getId() {
        return this.id;
    }

    @NonNull
    public Object getSource() {
        return this.source;
    }

    @NonNull
    public String[] getPatterns() {
        return this.patterns;
    }

    @NonNull
    public String[] getMethods() {
        if (this.methods == null) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return this.methods;
    }

    @NonNull
    public String[] getParams() {
        if (this.params == null) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return this.params;
    }

    @NonNull
    public String[] getHeaders() {
        if (this.headers == null) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return this.headers;
    }

    @NonNull
    public String[] getConsumes() {
        if (this.consumes == null) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return this.consumes;
    }

    @NonNull
    public String[] getProduces() {
        if (this.produces == null) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return this.produces;
    }

    public <V> WebEndpointMapping<E> setAttribute(String name, @Nullable V value) {
        if (value != null) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(name, value);
        }
        return this;
    }

    @Nullable
    public <V> V getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return (V)this.attributes.get(name);
    }

    public String toJSON() {
        StringBuilder stringBuilder = new StringBuilder("{").append(SeparatorConstants.LINE_SEPARATOR);
        this.append(stringBuilder, "id", this.id);
        this.append(stringBuilder, "patterns", this.patterns, ",", SeparatorConstants.LINE_SEPARATOR);
        this.append(stringBuilder, "methods", this.methods, ",", SeparatorConstants.LINE_SEPARATOR);
        this.append(stringBuilder, "params", this.params, ",", SeparatorConstants.LINE_SEPARATOR);
        this.append(stringBuilder, "headers", this.headers, ",", SeparatorConstants.LINE_SEPARATOR);
        this.append(stringBuilder, "consumes", this.consumes, ",", SeparatorConstants.LINE_SEPARATOR);
        this.append(stringBuilder, "produces", this.produces, ",", SeparatorConstants.LINE_SEPARATOR);
        stringBuilder.append(SeparatorConstants.LINE_SEPARATOR).append("}");
        return stringBuilder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebEndpointMapping that = (WebEndpointMapping)o;
        return Arrays.equals(this.patterns, that.patterns) && Arrays.equals(this.methods, that.methods) && Arrays.equals(this.params, that.params) && Arrays.equals(this.headers, that.headers) && Arrays.equals(this.consumes, that.consumes) && Arrays.equals(this.produces, that.produces);
    }

    public int hashCode() {
        int hashCode = this.hashCode;
        if (hashCode == 0) {
            hashCode = Arrays.hashCode(this.patterns);
            if (this.methods != null) {
                hashCode = 31 * hashCode + Arrays.hashCode(this.methods);
            }
            if (this.params != null) {
                hashCode = 31 * hashCode + Arrays.hashCode(this.params);
            }
            if (this.headers != null) {
                hashCode = 31 * hashCode + Arrays.hashCode(this.headers);
            }
            if (this.consumes != null) {
                hashCode = 31 * hashCode + Arrays.hashCode(this.consumes);
            }
            if (this.produces != null) {
                hashCode = 31 * hashCode + Arrays.hashCode(this.produces);
            }
            this.hashCode = hashCode;
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebEndpointMapping{");
        sb.append("kind=").append((Object)this.kind);
        sb.append(", endpoint=").append(this.endpoint);
        sb.append(", id=").append(this.id);
        sb.append(", source=").append(this.source);
        sb.append(", patterns=").append(Arrays.toString(this.patterns));
        sb.append(", methods=").append(Arrays.toString(this.methods));
        sb.append(", params=").append(Arrays.toString(this.params));
        sb.append(", headers=").append(Arrays.toString(this.headers));
        sb.append(", consumes=").append(Arrays.toString(this.consumes));
        sb.append(", produces=").append(Arrays.toString(this.produces));
        sb.append('}');
        return sb.toString();
    }

    private void append(StringBuilder appendable, String name, int value) {
        this.append(appendable, name);
        appendable.append(':').append(value);
    }

    private void append(StringBuilder appendable, String name, String[] values, String ... prefixes) {
        int size = ArrayUtils.size((Object[])values);
        if (size < 1) {
            return;
        }
        this.append(prefixes, appendable);
        this.append(appendable, name);
        appendable.append(':');
        appendable.append('[');
        for (int i = 0; i < size; ++i) {
            String value = values[i];
            this.append(appendable, value);
            if (i == size - 1) continue;
            appendable.append(',');
        }
        appendable.append(']');
    }

    private void append(StringBuilder appendable, String appended) {
        if (appended == null) {
            return;
        }
        appendable.append('\"').append(appended).append('\"');
    }

    private void append(String[] values, StringBuilder appendable) {
        for (int i = 0; i < values.length; ++i) {
            appendable.append(values[i]);
        }
    }

    public static class Builder<E> {
        private final Kind kind;
        private final E endpoint;
        private Object source;
        private final String[] patterns;
        private String[] methods;
        private String[] params;
        private String[] headers;
        private String[] consumes;
        private String[] produces;

        private Builder(Kind kind, E endpoint, String[] patterns) {
            Assert.isTrue((!ObjectUtils.isEmpty((Object[])patterns) ? 1 : 0) != 0, (String)"The patterns must not be empty!");
            this.kind = kind == null ? Kind.CUSTOMIZED : kind;
            this.endpoint = endpoint == null ? NON_ENDPOINT : endpoint;
            this.patterns = patterns;
        }

        public <V> Builder<E> methods(Collection<V> values, Function<V, String> stringFunction) {
            return this.methods(this.toStrings(values, stringFunction));
        }

        public Builder<E> methods(String ... methods) {
            this.methods = methods;
            return this;
        }

        public <V> Builder<E> params(Collection<V> values, Function<V, String> stringFunction) {
            return this.params(this.toStrings(values, stringFunction));
        }

        public Builder<E> params(String ... params) {
            this.params = params;
            return this;
        }

        public <V> Builder<E> headers(Collection<V> values, Function<V, String> stringFunction) {
            return this.headers(this.toStrings(values, stringFunction));
        }

        public Builder<E> headers(String ... headers) {
            this.headers = headers;
            return this;
        }

        public <V> Builder<E> consumes(Collection<V> values, Function<V, String> stringFunction) {
            return this.consumes(this.toStrings(values, stringFunction));
        }

        public Builder<E> consumes(String ... consumes) {
            this.consumes = consumes;
            return this;
        }

        public <V> Builder<E> produces(Collection<V> values, Function<V, String> stringFunction) {
            return this.produces(this.toStrings(values, stringFunction));
        }

        public Builder<E> produces(String ... produces) {
            this.produces = produces;
            return this;
        }

        public Builder<E> source(Object source) {
            this.source = source;
            return this;
        }

        protected <V> String[] toStrings(Collection<V> values, Function<V, String> stringFunction) {
            if (values.isEmpty()) {
                return StringUtils.EMPTY_STRING_ARRAY;
            }
            return (String[])values.stream().map(stringFunction).toArray(String[]::new);
        }

        public WebEndpointMapping build() {
            return new WebEndpointMapping(this.kind, this.endpoint, this.source, this.patterns, this.methods, this.params, this.headers, this.consumes, this.produces);
        }
    }

    public static enum Kind {
        SERVLET,
        FILTER,
        WEB_MVC,
        WEB_FLUX,
        CUSTOMIZED;

    }
}

