/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.method.support;

import io.microsphere.spring.context.event.OnceApplicationContextEventListener;
import io.microsphere.spring.util.BeanUtils;
import io.microsphere.spring.web.method.support.HandlerMethodAdvice;
import io.microsphere.spring.web.method.support.HandlerMethodArgumentInterceptor;
import io.microsphere.spring.web.method.support.HandlerMethodInterceptor;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.HandlerMethod;

public class DelegatingHandlerMethodAdvice
extends OnceApplicationContextEventListener<ContextRefreshedEvent>
implements HandlerMethodAdvice {
    public static final String BEAN_NAME = "delegatingHandlerMethodAdvice";
    private static final Logger logger = LoggerFactory.getLogger(DelegatingHandlerMethodAdvice.class);
    private List<HandlerMethodArgumentInterceptor> argumentInterceptors = Collections.emptyList();
    private int argumentInterceptorsSize = 0;
    private List<HandlerMethodInterceptor> methodInterceptors = Collections.emptyList();
    private int methodInterceptorsSize = 0;

    protected void onApplicationContextEvent(ContextRefreshedEvent event) {
        ApplicationContext context = event.getApplicationContext();
        this.initHandlerMethodArgumentInterceptors(context);
        this.initHandlerMethodInterceptors(context);
        this.log(context);
    }

    private void log(ApplicationContext context) {
        if (logger.isInfoEnabled()) {
            logger.info("{} HandlerMethodArgumentInterceptors and {} HandlerMethodInterceptors were initialized in the ApplicationContext[id : '{}']", new Object[]{this.argumentInterceptorsSize, this.methodInterceptorsSize, context.getId()});
        }
    }

    @Override
    public void beforeResolveArgument(MethodParameter parameter, HandlerMethod handlerMethod, NativeWebRequest webRequest) throws Exception {
        if (this.argumentInterceptorsSize > 0) {
            for (int i = 0; i < this.argumentInterceptorsSize; ++i) {
                HandlerMethodArgumentInterceptor interceptor = this.argumentInterceptors.get(i);
                interceptor.beforeResolveArgument(parameter, handlerMethod, webRequest);
            }
        }
    }

    @Override
    public void afterResolveArgument(MethodParameter parameter, Object resolvedArgument, HandlerMethod handlerMethod, NativeWebRequest webRequest) throws Exception {
        if (this.argumentInterceptorsSize > 0) {
            for (int i = 0; i < this.argumentInterceptorsSize; ++i) {
                HandlerMethodArgumentInterceptor interceptor = this.argumentInterceptors.get(i);
                interceptor.afterResolveArgument(parameter, resolvedArgument, handlerMethod, webRequest);
            }
        }
    }

    @Override
    public void beforeExecuteMethod(HandlerMethod handlerMethod, Object[] args, NativeWebRequest request) throws Exception {
        if (this.methodInterceptorsSize > 0) {
            for (int i = 0; i < this.methodInterceptorsSize; ++i) {
                HandlerMethodInterceptor interceptor = this.methodInterceptors.get(i);
                interceptor.beforeExecute(handlerMethod, args, request);
            }
        }
    }

    @Override
    public void afterExecuteMethod(HandlerMethod handlerMethod, Object[] args, Object returnValue, Throwable error, NativeWebRequest request) throws Exception {
        if (this.methodInterceptorsSize > 0) {
            for (int i = 0; i < this.methodInterceptorsSize; ++i) {
                HandlerMethodInterceptor interceptor = this.methodInterceptors.get(i);
                interceptor.afterExecute(handlerMethod, args, returnValue, error, request);
            }
        }
    }

    private void initHandlerMethodArgumentInterceptors(ApplicationContext context) {
        List argumentInterceptors;
        this.argumentInterceptors = argumentInterceptors = BeanUtils.getSortedBeans((ListableBeanFactory)context, HandlerMethodArgumentInterceptor.class);
        this.argumentInterceptorsSize = argumentInterceptors.size();
    }

    private void initHandlerMethodInterceptors(ApplicationContext context) {
        List interceptors;
        this.methodInterceptors = interceptors = BeanUtils.getSortedBeans((ListableBeanFactory)context, HandlerMethodInterceptor.class);
        this.methodInterceptorsSize = interceptors.size();
    }
}

