/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.WebRequestRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.NativeWebRequest;

public class CompositeWebRequestRule
implements WebRequestRule {
    private List<WebRequestRule> webRequestRules;

    public CompositeWebRequestRule(WebRequestRule ... requestRules) {
        this.webRequestRules = ObjectUtils.isEmpty((Object[])requestRules) ? Collections.emptyList() : Arrays.asList(requestRules);
    }

    @Override
    public boolean matches(NativeWebRequest request) {
        for (WebRequestRule webRequestRule : this.webRequestRules) {
            if (webRequestRule.matches(request)) continue;
            return false;
        }
        return true;
    }
}

