/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.AbstractNameValueExpression;
import io.microsphere.util.ArrayUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.WebUtils;

public class WebRequestHeaderExpression
extends AbstractNameValueExpression<String> {
    private final Set<String> namesToMatch = new HashSet<String>(WebUtils.SUBMIT_IMAGE_SUFFIXES.length + 1);

    public WebRequestHeaderExpression(String expression) {
        super(expression);
        this.namesToMatch.add(this.getName());
        for (String suffix : WebUtils.SUBMIT_IMAGE_SUFFIXES) {
            this.namesToMatch.add(this.getName() + suffix);
        }
    }

    @Override
    protected boolean isCaseSensitiveName() {
        return false;
    }

    @Override
    protected String parseValue(String valueExpression) {
        return valueExpression;
    }

    @Override
    protected boolean matchName(NativeWebRequest request) {
        return request.getHeader(this.name) != null;
    }

    @Override
    protected boolean matchValue(NativeWebRequest request) {
        Object[] values = request.getHeaderValues(this.name);
        return ObjectUtils.containsElement((Object[])values, (Object)this.value);
    }

    protected static List<WebRequestHeaderExpression> parseExpressions(String ... headers) {
        List<WebRequestHeaderExpression> expressions = Collections.emptyList();
        int size = ArrayUtils.size((Object[])headers);
        if (size > 0) {
            expressions = new ArrayList<WebRequestHeaderExpression>(size);
            for (int i = 0; i < size; ++i) {
                String header = headers[i];
                WebRequestHeaderExpression expression = new WebRequestHeaderExpression(header);
                if ("Accept".equalsIgnoreCase(expression.name) || "Content-Type".equalsIgnoreCase(expression.name)) continue;
                expressions.add(expression);
            }
        }
        return expressions;
    }
}

