/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.AbstractWebRequestRule;
import io.microsphere.spring.web.rule.WebRequestHeaderExpression;
import java.util.Collection;
import java.util.List;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestHeadersRule
extends AbstractWebRequestRule<WebRequestHeaderExpression> {
    private final List<WebRequestHeaderExpression> expressions;

    public WebRequestHeadersRule(String ... params) {
        this.expressions = WebRequestHeaderExpression.parseExpressions(params);
    }

    @Override
    protected Collection<WebRequestHeaderExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public boolean matches(NativeWebRequest request) {
        for (WebRequestHeaderExpression expression : this.expressions) {
            if (expression.match(request)) continue;
            return false;
        }
        return true;
    }
}

