/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.collection.SetUtils;
import io.microsphere.spring.web.rule.AbstractWebRequestRule;
import io.microsphere.spring.web.util.WebRequestUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestMethodsRule
extends AbstractWebRequestRule<String> {
    private final Set<String> methods;

    public WebRequestMethodsRule(RequestMethod ... requestMethods) {
        this.methods = ObjectUtils.isEmpty((Object[])requestMethods) ? Collections.emptySet() : Stream.of(requestMethods).map(Enum::name).collect(Collectors.toSet());
    }

    public WebRequestMethodsRule(String method, String ... others) {
        this.methods = ObjectUtils.isEmpty((Object[])others) ? Collections.singleton(method) : SetUtils.asSet((Object)method, (Object[])others);
    }

    @Override
    protected Collection<String> getContent() {
        return this.methods;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public boolean matches(NativeWebRequest request) {
        if (WebRequestUtils.isPreFlightRequest(request)) {
            return false;
        }
        String method = WebRequestUtils.getMethod(request);
        return this.matches(method);
    }

    public boolean matches(String method) {
        if (this.isEmpty()) {
            return !RequestMethod.OPTIONS.name().equals(method);
        }
        return this.matchRequestMethod(method);
    }

    private boolean matchRequestMethod(String method) {
        return this.methods.contains(method);
    }
}

