/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.AbstractNameValueExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.ObjectUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.WebUtils;

public class WebRequestParamExpression
extends AbstractNameValueExpression<String> {
    private final Set<String> namesToMatch = new HashSet<String>(WebUtils.SUBMIT_IMAGE_SUFFIXES.length + 1);

    public WebRequestParamExpression(String expression) {
        super(expression);
        this.namesToMatch.add(this.getName());
        for (String suffix : WebUtils.SUBMIT_IMAGE_SUFFIXES) {
            this.namesToMatch.add(this.getName() + suffix);
        }
    }

    @Override
    protected boolean isCaseSensitiveName() {
        return true;
    }

    @Override
    protected String parseValue(String valueExpression) {
        return valueExpression;
    }

    @Override
    protected boolean matchName(NativeWebRequest request) {
        for (String current : this.namesToMatch) {
            if (request.getParameter(current) == null) continue;
            return true;
        }
        return request.getParameter(this.name) != null;
    }

    @Override
    protected boolean matchValue(NativeWebRequest request) {
        Object[] parameterValues = request.getParameterValues(this.name);
        return ObjectUtils.containsElement((Object[])parameterValues, (Object)this.value);
    }

    protected static List<WebRequestParamExpression> parseExpressions(String ... params) {
        if (ObjectUtils.isEmpty((Object[])params)) {
            return Collections.emptyList();
        }
        int length = params.length;
        ArrayList<WebRequestParamExpression> expressions = new ArrayList<WebRequestParamExpression>(length);
        for (int i = 0; i < length; ++i) {
            String param = params[i];
            expressions.add(new WebRequestParamExpression(param));
        }
        return expressions;
    }
}

