/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.AbstractWebRequestRule;
import io.microsphere.spring.web.rule.WebRequestParamExpression;
import java.util.Collection;
import java.util.List;
import org.springframework.web.context.request.NativeWebRequest;

public class WebRequestParamsRule
extends AbstractWebRequestRule<WebRequestParamExpression> {
    private final List<WebRequestParamExpression> expressions;

    public WebRequestParamsRule(String ... params) {
        this.expressions = WebRequestParamExpression.parseExpressions(params);
    }

    @Override
    protected Collection<WebRequestParamExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " && ";
    }

    @Override
    public boolean matches(NativeWebRequest request) {
        int size = this.expressions.size();
        for (int i = 0; i < size; ++i) {
            WebRequestParamExpression expression = this.expressions.get(i);
            if (expression.match(request)) continue;
            return false;
        }
        return true;
    }
}

