/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.spring.web.rule;

import io.microsphere.spring.web.rule.AbstractWebRequestRule;
import io.microsphere.spring.web.util.WebRequestUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.util.UrlPathHelper;

public class WebRequestPattensRule
extends AbstractWebRequestRule<String> {
    private static final Set<String> EMPTY_PATH_PATTERN = Collections.singleton("");
    private final Set<String> patterns;
    private final PathMatcher pathMatcher;
    private final boolean useSuffixPatternMatch;
    private final boolean useTrailingSlashMatch;
    private final List<String> fileExtensions = new ArrayList<String>();

    public WebRequestPattensRule(String ... patterns) {
        this(patterns, true, null);
    }

    public WebRequestPattensRule(String[] patterns, boolean useTrailingSlashMatch, @Nullable PathMatcher pathMatcher) {
        this(patterns, null, pathMatcher, useTrailingSlashMatch);
    }

    @Deprecated
    public WebRequestPattensRule(String[] patterns, @Nullable UrlPathHelper urlPathHelper, @Nullable PathMatcher pathMatcher, boolean useTrailingSlashMatch) {
        this(patterns, urlPathHelper, pathMatcher, false, useTrailingSlashMatch);
    }

    public WebRequestPattensRule(String[] patterns, @Nullable UrlPathHelper urlPathHelper, @Nullable PathMatcher pathMatcher, boolean useSuffixPatternMatch, boolean useTrailingSlashMatch) {
        this(patterns, urlPathHelper, pathMatcher, useSuffixPatternMatch, useTrailingSlashMatch, null);
    }

    public WebRequestPattensRule(String[] patterns, @Nullable UrlPathHelper urlPathHelper, @Nullable PathMatcher pathMatcher, boolean useSuffixPatternMatch, boolean useTrailingSlashMatch, @Nullable List<String> fileExtensions) {
        this.patterns = WebRequestPattensRule.initPatterns(patterns);
        this.pathMatcher = pathMatcher != null ? pathMatcher : new AntPathMatcher();
        this.useSuffixPatternMatch = useSuffixPatternMatch;
        this.useTrailingSlashMatch = useTrailingSlashMatch;
        if (fileExtensions != null) {
            for (String fileExtension : fileExtensions) {
                if (fileExtension.charAt(0) != '.') {
                    fileExtension = "." + fileExtension;
                }
                this.fileExtensions.add(fileExtension);
            }
        }
    }

    @Override
    protected Collection<String> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public boolean matches(NativeWebRequest request) {
        if (WebRequestUtils.isPreFlightRequest(request)) {
            return false;
        }
        String lookupPath = WebRequestUtils.getResolvedLookupPath(request);
        return this.matches(lookupPath);
    }

    public boolean matches(String lookupPath) {
        List<String> matches = this.getMatchingPatterns(lookupPath);
        return !matches.isEmpty();
    }

    public List<String> getMatchingPatterns(String lookupPath) {
        List matches = null;
        for (String pattern : this.patterns) {
            String match = this.getMatchingPattern(pattern, lookupPath);
            if (match == null) continue;
            matches = matches != null ? matches : new ArrayList();
            matches.add(match);
        }
        if (matches == null) {
            return Collections.emptyList();
        }
        if (matches.size() > 1) {
            matches.sort(this.pathMatcher.getPatternComparator(lookupPath));
        }
        return matches;
    }

    @Nullable
    protected String getMatchingPattern(String pattern, String lookupPath) {
        if (pattern.equals(lookupPath)) {
            return pattern;
        }
        if (this.useSuffixPatternMatch) {
            if (!this.fileExtensions.isEmpty() && lookupPath.indexOf(46) != -1) {
                for (String extension : this.fileExtensions) {
                    if (!this.pathMatcher.match(pattern + extension, lookupPath)) continue;
                    return pattern + extension;
                }
            } else {
                boolean hasSuffix;
                boolean bl = hasSuffix = pattern.indexOf(46) != -1;
                if (!hasSuffix && this.pathMatcher.match(pattern + ".*", lookupPath)) {
                    return pattern + ".*";
                }
            }
        }
        if (this.pathMatcher.match(pattern, lookupPath)) {
            return pattern;
        }
        if (this.useTrailingSlashMatch && !pattern.endsWith("/") && this.pathMatcher.match(pattern + "/", lookupPath)) {
            return pattern + "/";
        }
        return null;
    }

    private static Set<String> initPatterns(String[] patterns) {
        if (!WebRequestPattensRule.hasPattern(patterns)) {
            return EMPTY_PATH_PATTERN;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(patterns.length);
        for (String pattern : patterns) {
            if (StringUtils.hasLength((String)pattern) && !pattern.startsWith("/")) {
                pattern = "/" + pattern;
            }
            result.add(pattern);
        }
        return result;
    }

    private static boolean hasPattern(String[] patterns) {
        if (!ObjectUtils.isEmpty((Object[])patterns)) {
            for (String pattern : patterns) {
                if (!StringUtils.hasText((String)pattern)) continue;
                return true;
            }
        }
        return false;
    }
}

